; file: makefigSBJtempeps2.pro = main to make fig SBJ-temp + eps2 + Lambda
; init: May 25 2016  Rob Rutten  Mitaka
; last: Jul 15 2022  Rob Rutten  Deil
; note: parameter-free except xrange, yrange axis tuning etc
;       for PRD lines give wavpeak, wavdip, wavwing in doinitline.pro

;; pro dummy 

; start SBJ figure
; ---------------
eltemp=atmos.T
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-SBJtemp-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect
xtitle='height  [km]'
ytitle='B, S, J  as '+textoidl("T_{e}, T_{exc}, T_{rad}  [K]")
xrange=heightrange
yrange=temprange
if (yrange[1]-yrange[0] lt 5000) then ytickinterval=1000 $
  else if  (yrange[1]-yrange[0] lt 10000) then ytickinterval=2000 $
  else  ytickinterval=5000
plot,heightkm,eltemp,$
  position=[0.2,0.2,0.85,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/plotaspect,$   ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  thick=1,$ ;  solid = electron temperature
  xrange=xrange,xstyle=1,$
  yrange=yrange,ystyle=9,ytickinterval=ytickinterval,ytickformat='(I8)'

;; ; add model name
;; xyouts,0.24,0.25,/norm,modelname

;; ; add line name
;; xyouts,0.24,0.32,/norm,pslinelabel

; add T curve identifier at h=1300 km ; Jul 15 2022 was 1500 km 
ih13=min(where(heightkm-1300. lt 0))
xyouts,heightkm[ih13],eltemp[ih13]+200,textoidl("T_e")

;; ; add tau expanantion for ticks at 0.3, 1, 3 
;; tauident=textoidl("| | |  \tau_\nu = 3, 1, 0.3")
;; xyouts,0.23,0.25,/norm,tauident,charsize=0.9

; if PRD then large loop over sample wavs, otherwise line center only
;;if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip,iwavwing] else iwavarr=[iwavlc] ;RR same as dip and too confusing
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot] 

; compute J_bar = R_lu/B_lu (holds also for PRD)
  @constants_si.idl
  Rlu=*thisatom.transition[itrans].Rij_ptr
  gl=thisatom.g[ilow]
  gu=thisatom.g[jupp]
  Aul=thisatom.transition[itrans].strength
  Blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
  Jbar=Rlu/Blu

; compute various source functions
  readj,iwavplot
  readopacity,iwavplot
  Sline=eta_as/chi_as    
  Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
  if (PRD) then Jplot=J else Jplot=Jbar ; monochromatic or freq average
;;  Jplot=J

; convert into formal temperature
;; Bnu=planck(atmos.T,wavlc,/hz)  ; needed double() in brighttemp.pro
;; eltemp=brighttemp(wavlc,Bnu,/Hz)
  exctemp=brighttemp(wavlc,Sline,/Hz)
  tottemp=brighttemp(wavlc,Stotal,/Hz)
  radtemp=brighttemp(wavlc,Jplot,/Hz)
  if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; overplot these
  oplot,heightkm,tottemp,linestyle=0  ; solid, total source function
;;  oplot,heightkm,exctemp,linestyle=1   ; dotted, S^l
  oplot,heightkm,radtemp,linestyle=2   ; dashed, J_bar or J
;;  if (PRD) then oplot,heightkm,bartemp,linestyle=3  ; dotdashed, J_bar

; add tau ticks on S^total
  tau=fltarr(nh)
  tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
;;  tabinv,tau,[0.3,1.0,3.0],tau_label
  tabinv,tau,[1E10,1E8,1E6,1E4,1E3,1E2,1E1,1,1E-1,1E-2,1E-3,1E-4],tau_label
  tauname=['10','8','6','4','3','2','1','0','-1','-2','-3','-4']
  xtau=linear(heightkm,tau_label)
  ytau=linear(tottemp,tau_label)
  ydash=(yrange[1]-yrange[0])/20.
  sizetau=size(tau_label)
  for itau=0,sizetau[1]-1 do begin
    xtick=[xtau[itau],xtau[itau]]
    ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
    if (xtick[0] gt xrange[0]+50 and xtick[0] lt xrange[1]-50 and $
        ytick[0] gt yrange[0]+0.01*(yrange[1]-yrange[0]) and $
        ytick[1] lt yrange[1]-0.1*(yrange[1]-yrange[0])) then begin
      oplot,xtick,ytick
      xyouts,xtau[itau],ytau[itau]+ydash*1.5,tauname[itau],$
        alignment=0.5,charsize=0.8
; store linecenter extinction, tau, height tau_lc=1 
      if (iw eq 0) then begin
        chi0=chi_as
        tau0=tau
        xtau01=xtau[7]
      endif
    endif
  endfor

; end big loop over wavs
endfor

; get epsilon_acc 
; compute epsacc(h) and epsacc*B(h)
Aul=thisatom.transition[itrans].strength
Cul=(*thisatom.Cij_ptr)[*,jupp,ilow]
@constants_si.idl
epsacc=(1.-exp(-hplanck*clight/(wavlc*nm_to_m*kboltzmann*atmos.t)))*Cul/Aul
eps2lev=epsacc/(1.+epsacc)
logeps=alog10(eps2lev)

; get thermalization length (NB: at large density more ~/eps^2)
; Gaussian-profile 2-level atom in CRD: Lambda = 1./(alpha * epsilon)
ther=sqrt(!pi)/(chi0*eps2lev) ; mean chi for Gauss = (1/sqrt(pi) chi_0
logther=alog10(ther/1.E9)     ; units m > Gm 

; oplot logeps transformed to temperature axis
mineps=min(logeps)-8.   ;RR suppress TR part
mineps=-6.5
maxeps=0.5
epstemp=(logeps-mineps)/(maxeps-mineps)*(yrange[1]-yrange[0])+yrange[0]
oplot,heightkm,epstemp,linestyle=1

; oplot logther transformed to temperature axis
thertemp=(logther-mineps)/(maxeps-mineps)*(yrange[1]-yrange[0])+yrange[0]
oplot,heightkm,thertemp,linestyle=4

; add epsilon/Lambda axis to the right
axis,yaxis=1,yrange=[mineps,maxeps],ystyle=1,ytickinterval=2,yminor=2,$
  ytitle=textoidl("log (\varepsilon_2)       log (\Lambda_2)  [Gm]")

; add eps label
ih13=min(where(heightkm-1300. lt 0))
xyouts,heightkm[ih13],epstemp[ih13]+200,textoidl("\varepsilon_2")

; add Lambda label at tau_lc = 1/eps[tau=1] approx thermalization point
ihtau01=min(where(heightkm-xtau01 lt 0))
epslam=eps2lev[ihtau01]
ihlam=min(where(tau0-1./epslam gt  0))
if (ihlam eq -1) then ihlam=nh-10  ; BaII has it out of range
xyouts,heightkm[ihlam]-75,thertemp[ihlam]+400,textoidl("\Lambda_2")

; add model name
xyouts,0.23,0.23,/norm,modelname

; add line name
xyouts,0.62,0.23,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
