; file: makefigSBJtempedges.pro = main to produce SBJ temp figure
; init: Nov 11 2016  Rob Rutten  Deil from makefigSBJtemp.pro 
; last: Aug  3 2018  Rob Rutten  Deil 
; note: run with   @doinitrh   .r makefigSBJtempedges

; this program produces SBJ as temp plot for wavelength-specified edges 

; ========== parameter settings 

; file name and plot labels
;; modelname='FCHHT-B'
;; modelname='ALC7'
modelname='FALP'
;; modelname='FALC'
;; spectrumname='Mg I'
spectrumname=''
;; psfilename='fig-SBJtempedges-MgI'+'.ps'
psfilename='fig-SBJtempedges-'+modelname+'.ps'

; edge selection (as many as you want)
;; aaedges=[1621,2513]   ; MgI upper (edge) wavelengths in AA
;; aaedges=[3500,3000,2500,2000,1500]
aaedges=[3500,2500,1500]
aaextent=100           ; summation extent below threshold in AA

;RR very deep line at 2514, when included much higher formation
;RR so better play with the upper wav, also with extent

; edge labels
;; edgenames=['3500','3000','2500','2000','1500']
edgenames=['3500','2500','1500']
;; edgenames=['1-c  1622','2-c  2514']  ; MgI ledges
;; ihlabel=100                          ; height index for ALC7 label placement
ihlabel=60

; axis stuff 
;; xrange=[-100,2300]   ; standard ALC7 graphs
;; xrange=[-20,1480]
xrange=[-20,1280]
xtickinterval=200
xminor=2
yrange=[4000,7000]
ytickinterval=1000

; define gv opening or not (=1 for new; =0 to keep size if resized)
opengv=1

; =========== end parameter part, rest should be parameter-free

; check sizes
nedges=n_elements(aaedges)
nlabels=n_elements(edgenames)
if (nlabels ne nedges) then begin
  print,' ###### abort: nr labels neq nr edges'
  return
endif

; find edge wavelength indices 
nmedges=aaedges/10.
iedges=lonarr(nedges)
for iedge=0,nedges-1 do begin
  wav=nmedges[iedge]
  iwav=where(abs(spectrum.lambda-wav) eq min(abs(spectrum.lambda-wav)))
  iedges[iedge]=iwav[0]
endfor

; start SBJ figure
; ---------------

; first plot temperature 
; ## should be 100-AA average B^-1[B(T_e)] over the edge too?
eltemp=atmos.T
if (opengv) then spawn,'pkill -s 0 gv'
plotaspect=1.62
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect
xtitle='height  [km]'
ytitle='B, S, J  [K]'
;; if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
;; if (maxplotheight eq 0) then maxplotheight=max(heightkm)
;; xrange=[min(heightkm),maxplotheight]
;; ymin=min(exctemp)
;; ymax=max(eltemp)
;; yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
plot,heightkm,eltemp,$
  position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/plotaspect,$   ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  thick=1,$
  xtickinterval=xtickinterval,xminor=xminor,$
  ytickinterval=ytickinterval,$
  xrange=xrange,xstyle=1, yrange=yrange,ystyle=1

; add model name
xyouts,0.28,0.85,/norm,modelname

; add spectrum name
xyouts,0.28,0.78,/norm,spectrumname

; start loop over edges
for iedge=0,nedges-1 do begin

; edge wav
  iwav2=iedges[iedge]
  wav2=nmedges[iedge]   ; nm 

; find starting wav1 and iwav1 at requested averaging extent 
  wav1=wav2-aaextent/10.
  iwav=where(abs(spectrum.lambda-wav1) eq min(abs(spectrum.lambda-wav1)))
  iwav1=iwav[0]

; compute, sum, average S and J  ;## Nov 10 2016 should have averaged B too?
  nh=n_elements(heightkm)
  Smean=dblarr(nh)
  Jmean=dblarr(nh)
  for iwav=iwav1,iwav2 do begin
    readj,iwav
    readopacity,iwav
    Smean=Smean+(eta_c+J*scatt)/chi_c
    Jmean=Jmean+J
  endfor
  Smean=Smean/(iwav2-iwav1)
  Jmean=Jmean/(iwav2-iwav1)

; convert into formal temperature
  meanwav=(wav1+wav2)/2.
  exctemp=brighttemp(meanwav,Smean,/Hz)
  radtemp=brighttemp(meanwav,Jmean,/Hz)

; overplot these
  oplot,heightkm,exctemp,linestyle=1   ; dotted S
  oplot,heightkm,radtemp,linestyle=2   ; dashed J

; add tau ticks
  tau=fltarr(nh)
  tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
  valtau=[0.3,1.0,3.0]
  tabinv,tau,valtau,tau_eff
  ytau=linear(exctemp,tau_eff)
  xtau=linear(heightkm,tau_eff)
  ydash=(yrange[1]-yrange[0])/20.
  for itau=0,2 do begin
    xtick=[xtau[itau],xtau[itau]]
    ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
    ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
    oplot,xtick,ytick
  endfor

; add edge identifier (must be in plotting loop for AA)
  angstrom=cgsymbol("angstrom")
  edgelabel=edgenames[iedge]+' '+angstrom

;; ; auto-placement
;;   xyouts,heightkm[ihlabel],exctemp[ihlabel],edgelabel

; manual placment
if (iedge eq 0) then xyouts,600,5400,edgelabel
if (iedge eq 1) then xyouts,600,4900,edgelabel
if (iedge eq 2) then xyouts,830,4800,edgelabel

endfor

; close plot
closepsplot,psfilename,opengv=opengv

end

