; file: makefigSBJtemp.pro = main to produce SBJ temp figure
; init: Mar  6 2012 
; last: May 25 2016  Rob Rutten  Mitaka
; note: parameter-free except xrange, yrange axis tuning etc
;       for PRD lines give iwavpeak, iwavdip, iwavwing in doinitline.pro

; start SBJ figure
; ---------------
eltemp=atmos.T
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-SBJtemp-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect
xtitle='height  [km]'
ytitle='B, S, J  as '+textoidl("T_{e}, T_{exc}, T_{rad}  [K]")
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
;; xrange=[-100,2100]
xrange=[min(heightkm),maxplotheight]
; ymin=min(exctemp)
; ymax=max(eltemp)
; yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
;; yrange=[3000,7100]
yrange=[3000,9000]
yrange=[3000,7000]
plot,heightkm,eltemp,$
  position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/plotaspect,$   ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  thick=1,$ ;  solid = electron temperature
  xrange=xrange,xstyle=1, yrange=yrange,ystyle=1,ytickinterval=1000

; add model name
xyouts,0.28,0.85,/norm,modelname

; add line name
xyouts,0.28,0.78,/norm,pslinelabel

;; ; add tau identifier
;; tauident=textoidl("| | |  \tau_\nu = 3, 1, 0.3")
;; xyouts,0.23,0.25,/norm,tauident,charsize=0.9

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; if PRD then large loop over sample wavs, otherwise line center only
;;if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip,iwavwing] else iwavarr=[iwavlc] ;RR same as dip and too confusing
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot] 

; compute J_bar = R_lu/B_lu (holds also for PRD)
  @constants_si.idl
  Rlu=*thisatom.transition[itrans].Rij_ptr
  gl=thisatom.g[ilow]
  gu=thisatom.g[jupp]
  Aul=thisatom.transition[itrans].strength
  Blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
  Jbar=Rlu/Blu

; compute various source functions
  readj,iwavplot
  readopacity,iwavplot
  Sline=eta_as/chi_as    
  Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
  if (PRD) then Jplot=J else Jplot=Jbar ; monochromatic or freq average
;;  Jplot=J

; convert into formal temperature
;; Bnu=planck(atmos.T,wavlc,/hz)  ; needed double() in brighttemp.pro
;; eltemp=brighttemp(wavlc,Bnu,/Hz)
  exctemp=brighttemp(wavlc,Sline,/Hz)
  tottemp=brighttemp(wavlc,Stotal,/Hz)
  radtemp=brighttemp(wavlc,Jplot,/Hz)
  if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; overplot these
  oplot,heightkm,tottemp,linestyle=0  ; solid, total source function
;;  oplot,heightkm,exctemp,linestyle=1   ; dotted, S^l
  oplot,heightkm,radtemp,linestyle=2   ; dashed, J_bar or J
;;  if (PRD) then oplot,heightkm,bartemp,linestyle=3  ; dotdashed, J_bar

; add tau ticks
  tau=fltarr(nh)
  tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
;; tabinv,tau,[0.3,1.0,3.0],tau_eff
  tabinv,tau,[1E10,1E8,1E6,1E4,1E3,1E2,1E1,1,1E-1,1E-2,1E-3,1E-4],tau_eff
  tauname=['10','8','6','4','3','2','1','0','-1','-2','-3','-4']
  ytau=linear(exctemp,tau_eff)
  xtau=linear(heightkm,tau_eff)
  ydash=(yrange[1]-yrange[0])/20.
  sizetau=size(tau_eff)
  for itau=0,sizetau[1]-1 do begin
    xtick=[xtau[itau],xtau[itau]]
    if (xtick[0] gt xrange[0]+50 and xtick[0]  lt xrange[1]-50 $
      and xtick[0] lt 2100) then begin   ;RR cut TR also  
      ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
      oplot,xtick,ytick
      xyouts,xtau[itau],ytau[itau]+ydash*1.6,tauname[itau],$
        alignment=0.5,charsize=0.8
  endif
  endfor

; end big loop over wavs
endfor

; close plot
closepsplot,psfilename,opengv=opengv

end
