; file: makefigS2leveltemp.pro = main to produce 2-level S figures
; init: Mar  9 2012 Labrador
; last: Apr 23 2013 
; note: first run rhf1d on the desired XXX.atmos and XXX.atom RH setup
;       then in new IDL session first @dorhinit
;       parameter-free except xrange, yrange axis tuning etc

; compute epsacc(h) and epsacc*B(h)
Aul=thisatom.transition[itrans].strength
Cul=(*thisatom.Cij_ptr)[*,jupp,ilow]
@constants_si.idl
epsacc=(1.-exp(-hplanck*clight/(wavlc*nm_to_m*kboltzmann*atmos.t)))*Cul/Aul
epsaccB=epsacc*planck(atmos.T,wavlc,/hz)

; compute J_bar = R_lu/B_lu (holds also for PRD)
rlu=*thisatom.transition[itrans].Rij_ptr
gl=thisatom.g[ilow]
gu=thisatom.g[jupp]
blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
Jbar=rlu/blu

; compute various source functions
readj,iwavplot
readopacity,iwavplot
Sline=eta_as/chi_as    
Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
if (PRD) then Jplot=J  else Jplot=Jbar ; monochromatic or freq average
S2level=(Jplot+epsaccB)/(1.+epsacc)
exctemp=brighttemp(wavlc,Sline,/Hz)
tottemp=brighttemp(wavlc,Stotal,/Hz)
radtemp=brighttemp(wavlc,Jplot,/Hz)
twotemp=brighttemp(wavlc,S2level,/Hz)
if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; make figure source functions
; ----------------------------
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-S2leveltemp-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2
xtitle='height  [km]'
ytitle='B, S, J  as temperature [K]'
eltemp=atmos.T
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
;; xrange=[-100,2100]
;; yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
yrange=[3000,11000]
plot,heightkm,eltemp,$
    position=[0.2,0.2,0.95,0.95],/normal,$     ; ample margins
    xticklen=0.03,yticklen=0.03/plotaspect,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,xstyle=1, yrange=yrange,ystyle=1,$
    thick=4                            ; solid thick, Planck
oplot,heightkm,tottemp,linestyle=0     ; solid, total source function
oplot,heightkm,exctemp,linestyle=1     ; dotted, = S^l
oplot,heightkm,twotemp,linestyle=2     ; dashed, S_2-level
oplot,heightkm,radtemp,linestyle=3     ; dotdashed, J_bar or J
;; if (PRD) then oplot,heightkm,bartemp,linestyle=3  ; dotdashed, J_bar

; add tau ticks
tau=fltarr(nh)
tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
; tabinv,tau,[0.3,1.0,3.0],tau_eff
tabinv,tau,[1E4,1E3,1E2,1E1,1,1E-1,1E-2],tau_eff
xtau=linear(heightkm,tau_eff)
ytau=linear(tottemp,tau_eff)
ydash=(yrange[1]-yrange[0])/20.
; tauname=['0.3','1','3']
tauname=['4','3','2','1','0','-1','-2']
sizetau=size(tau_eff)
for itau=0,sizetau[1]-1 do begin
  xtick=[xtau[itau],xtau[itau]]
  ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
  oplot,xtick,ytick
  xyouts,xtau[itau],ytau[itau]+ydash*1.6,tauname[itau],$
    alignment=0.5,charsize=0.8
endfor

; add model name
xyouts,0.25,0.85,/norm,modelname

; add line name
xyouts,0.25,0.78,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv


; make figure relative eps(B-J) and eta(B*-J) contributions
; ---------------------------------------------------------
psfilename='fig-eps-eta-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2
xtitle='height  [km]'
ytitle='fractional contribution'
y=(Sline-Jplot)/Sline   ; = (S^l - J) / S^l 
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
ymin=min(y)
ymax=max(y)
yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
yrange=[-0.02,0.12]
plot,heightkm,y,$
    position=[0.2,0.2,0.95,0.95],/normal,$     ; ample margins
    xticklen=0.03,yticklen=0.03/plotaspect,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,xstyle=1,yrange=yrange,ystyle=1
oplot,heightkm,(S2level-Jplot)/Sline,linestyle=2   ; = eps (B - J) / S^l
oplot,heightkm,(Sline-S2level)/Sline,linestyle=3  ; = eta (B* - J) / S^l

; check sign (compare to SBJ plot)
; plot,heightkm,(S2level-Jplot)/Sline,yrange=[-0.1,+0.1]

;; ; add tau ticks
;; tau=fltarr(nh)
;; tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
;; tabinv,tau,[0.3,1.0,3.0],tau_eff
;; tauname=['0.3','1','3']
;; xtau=linear(heightkm,tau_eff)
;; ydash=(yrange[1]-yrange[0])/12.
;; for itau=0,2 do begin
;;   xtick=[xtau[itau],xtau[itau]]
;;   ytick=[yrange[0],yrange[0]+ydash]
;;   oplot,xtick,ytick
;;   xyouts,xtick,yrange[0]+ydash*1.2,tauname[itau],alignment=0.5,charsize=0.8
;; endfor

; add model name
xyouts,0.25,0.85,/norm,modelname

; add line name
xyouts,0.25,0.78,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
