; file: findline.pro = main to get RH active-line indices
; init: Feb 17 2012 
; last: Jul 17 2022  Rob Rutten  Deil
; note: must be called as .r so from an @script at the command line
;       wavs in nm, air where air; wavrange for profile plots = km/s

; open ps dummy momentarily to get Greek letters in ps line labels
openpsplot,'/tmp/psplotdummy.ps'

; ======= H lines

if (linename eq 'Halpha') then begin 
  filelinename='Halpha'  & pslinelabel='H '+greek("alpha") 
  element='H' & linewav=656.37  
  transinterval=0.2 
  neckel=1 & neckelshift=-0.008
  wavrange=75
endif 

if (linename eq 'Hbeta') then begin 
  filelinename='Hbeta'  & pslinelabel='H '+greek("beta") 
  element='H' & linewav=486.13
  transinterval=0.2 
  neckel=1 & neckelshift=-0.003
  wavrange=75
endif 

if (linename eq 'Lyalpha') then begin
  filelinename='Lyalpha'  & pslinelabel='Ly '+greek("alpha")
  element='H' & linewav=121.5
  delwavpeak=0.015 & delwavdip=0.04 & delwavwing=0.2  ; PRD
  neckel=0
  wavrange=170 & temprange=[3000,10000]
endif 

if (linename eq 'Lybeta') then begin
  filelinename='Lybeta'  & pslinelabel='Ly '+greek("beta")
  element='H' & linewav=102.6
  transinterval=0.2 
  neckel=0  
  wavrange=170 & temprange=[3000,10000]
endif 

; ======= Mg lines

if (linename eq 'MgIb1') then begin
  filelinename='MgIb1' &  pslinelabel='Mg I b!D1!N'
  element='MG' & linewav=517.8 
  neckel=1 & neckelshift=5.463  
  wavrange=30 & temprange=deftemprange
endif 

if (linename eq 'MgIb2') then begin
  filelinename='MgIb2' &  pslinelabel='Mg I b!D2!N'
  element='MG' & linewav=517.411
  transinterval=0.2 
  neckel=1 & neckelshift=0
  wavrange=30
endif 

if (linename eq 'MgI4571') then begin
  filelinename='MgI4571' &  pslinelabel='Mg I 4571'+string(197B)
  element='MG' & linewav=457.1
  transinterval=0.2 
  neckel=1 & neckelshift=0
  wavrange=8
endif 

if (linename eq 'MgIIk') then begin
  filelinename='MgIIk' & pslinelabel='Mg II k'
  element='MG' & linewav=279.55
  delwavpeak=0.013 & delwavdip=0.037 & delwavwing=0.1
  transinterval=0.2 
  neckel=0  
  wavrange=55
endif

if (linename eq 'MgIIh') then begin
  filelinename='MgIIh' & pslinelabel='Mg II h'
  element='MG' & linewav=280.27 
  delwavpeak=0.013 & delwavdip=0.037 & delwavwing=0.1
  transinterval=0.2 
  neckel=0 
  wavrange=55
endif 

; ======= CaII lines

if (linename eq 'CaIIK') then begin
  element='CA' & linewav=393.366
  filelinename='CaIIK' & pslinelabel='Ca II K'
  delwavpeak=0.009 & delwavdip=0.03 & delwavwing=0.1
  transinterval=0.2 
  neckel=1 & neckelshift=0  
  wavrange=55
endif 

if (linename eq 'CaIIH') then begin
  filelinename='CaIIH' & pslinelabel='Ca II H'
  element='CA' & linewav=396.6
  delwavpeak=0.009 & delwavdip=0.03 & delwavwing=0.1
  transinterval=0.2 
  neckel=1 & neckelshift=0 
  wavrange=55
endif 

if (linename eq 'CaII8542') then begin
  filelinename='CaII8542' & pslinelabel='Ca II 8542 '+string(197B)
  element='CA' & linewav=854.209
  transinterval=0.1
  neckel=1 & neckelshift=0   
  wavrange=30
endif 

; ====== He lines 

if (linename eq 'HeII304') then begin
  filelinename='HeII304' & pslinelabel='He II 304 '+string(197B)
  element='HE' & linewav=30.381
  transinterval=0.01
  neckel=0
  wavrange=55
endif

if (linename eq 'HeI584') then begin
  filelinename='HeI584' & pslinelabel='He I 584 '+string(197B)
  element='HE' & linewav=58.433
  delwavpeak=0.004 & delwavdip=0.01 & delwavwing=0.05
  transinterval=0.01
  neckel=0 
  wavrange=170 & betarange=[-1.5,+5] & temprange=[0,15000]
endif
 
if (linename eq 'HeI10830') then begin
  filelinename='HeI10830' & pslinelabel='He I 10830 '+string(197B)
  element='HE' & linewav=1083.033   ;; strongest compoment
  transinterval=0.001  
  neckel=1 & neckelshift=0 
  wavrange=8 & betarange=[-1.5,+5] & temprange=deftemprange
endif

if (linename eq 'HeID3') then begin
  filelinename='HeID3' & pslinelabel='He I 5876'+string(197B)
  element='HE' & linewav=587.5964  ;; strongest component
  transinterval=0.0002
  neckel=1 & neckelshift=0 
  wavrange=8 & betarange=[-1.5,+5] & temprange=deftemprange
endif

; ====== Fe lines

if (linename eq 'FeI6302') then begin
  filelinename='FeI6302' & pslinelabel='Fe I 6302 '+string(197B)
  element='FE' & linewav=630.15
  transinterval=0.02 
  neckel=1 & neckelshift=0
  wavrange=8
endif

; strong multiplet 4 from ground state
if (linename eq 'FeI3860') then begin
  filelinename='FeI3860' & pslinelabel='Fe I 3860 '+string(197B)
  element='FE' & linewav=385.99
  transinterval=0.2
  neckel=1 & neckelshift=0
  wavrange=30
endif

; FeI 6173 = HMI line Smitha ms Jun 21 2022, as 6302
if (linename eq 'FeI6173') then begin
  filelinename='FeI6173' & pslinelabel='Fe I 6173 '+string(197B)
  element='FE' & linewav=617.30
  transinterval=0.1
  neckel=1 & neckelshift=0
  wavrange=8
endif

; ====== loose lines

if (linename eq 'NaID1') then begin
  filelinename='NaID1' & pslinelabel='Na I D!D1!N'
  element='NA' & linewav=589.594
  transinterval=0.1
  neckel=1 & neckelshift=0   
  wavrange=30 & betarange=defbetarange & temprange=deftemprange
endif 

if (linename eq 'BaII4554') then begin
  filelinename='BaII4554' & pslinelabel='Ba II 4554 '+string(197B)
  element='BA' & linewav=455.404
  delwavpeak=0.004 & delwavdip=0.01 & delwavwing=0.05
  transinterval=0.2 
  neckel=1 & neckelshift=0
  wavrange=8
endif

; NiI 6768 = GONG+MDI line Jul 17 2022 as Smitha FeI
if (linename eq 'NiI6768') then begin
  filelinename='NiI6768' & pslinelabel='Ni I 6768 '+string(197B)
  element='NI' & linewav=676.78
  transinterval=0.1
  neckel=1 & neckelshift=0
  wavrange=8
endif

; =====================================================================

; close ps dummy 
;;closepsplot,'/tmp/psplotdummy.ps',opengv=0
  device,/close

; back to defaults
  set_plot,'X'          
  !p.font=-1            
  !p.thick=0 & !p.charthick=0 & !x.thick=0 & !y.thick=0

; get RH line stuff
nrtrans=0
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
thisatom=readatom('atom.'+element+'.out')
ntr=thisatom.nline+thisatom.ncont
for itr=0,ntr-1 do $
  if (abs(thisatom.transition[itr].lambda0-linewav) lt transinterval) $
  then begin
    wavlc=thisatom.transition[itr].lambda0
    tabinv,spectrum.lambda,wavlc,iwavlc
    itrans=itr
    nrtrans=nrtrans+1
    iwavlc=long(iwavlc+0.1)
    ilow=thisatom.transition[itr].i
    jupp=thisatom.transition[itr].j
    if (thisatom.transition[itrans].shape eq 2) then PRD=1 else PRD=0
    if (PRD) then begin
      wavpeak=wavlc+delwavpeak
      iwavpeak=where(abs(spectrum.lambda-wavpeak) eq $
        min(abs(spectrum.lambda-wavpeak)))
      wavdip=wavlc+delwavdip
      iwavdip=where(abs(spectrum.lambda-wavdip) eq $
        min(abs(spectrum.lambda-wavdip)))
      wavwing=wavlc+delwavwing
      iwavwing=where(abs(spectrum.lambda-wavwing) eq $
        min(abs(spectrum.lambda-wavwing)))
    endif
    if (transprint) then print,text,element,itr,$
      ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
      format='(A43, A3, I5, I3, I3, I7, F11.5, F11.5)'
  ;RR how to spread format statement over multiple lines?
    ;; strwavlc=string(wavlc)
    ;; spawn,'grep
    ;; /home/rutten/rr/wrk/linetables/kurucz/gfall.dat'+strwavlc
  endif
if (nrtrans eq 0) then print,' ### FINDLINE.PRO: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### FINDLINE.PRO: multiple lines found'

end



