; file: atfindline.pro = callable IDL sequence to get RH active-line indices
; init: Aug 12 2013  Rob Rutten, Lingezicht Astrophysics
; note: must be called as with @ from an IDL main program
; last: Dec 11 2016  Rob Rutten  Goettingen seems ########  NO LONGER IN USE

;; commented openpsplot out to be able to use @findline multiple times
;; within a figure making program (makefigtauTR.pro).
;; In such cases comment out the final end in this file and use @findline
;; afer openpsplot and produce the lin elabel there if it contains Greek


;; ; open ps dummy momentarily for Greek letters in ps line labels
;; openpsplot,'/tmp/psplotdummy.ps'

; H lines

; Halpha
if (linename eq 'Halpha') then begin 
  element='H' & linewav=656.37 
  filelinename='Halpha'  & pslinelabel='H '+greek("alpha") 
  wavrange=2 & addneckel=1 & neckelshift=-0.06 
endif 

; Lyalpha
if (linename eq 'Lyalpha') then begin
  element='H' & linewav=121.5
  filelinename='Lyalpha'  & pslinelabel='Ly '+greek("alpha")
  wavrange=1.8 & addneckel=0  & neckelshift=0
endif 

; Mg lines
  ; wrong wav, MgI+II.atom upper level = representative 
if (linename eq 'MgI4571') then begin
  element='MG' & linewav=456.68
  filelinename='MgI4571' & pslinelabel='Mg I 4571 '+string(197B)
  wavrange=0.3 & addneckel=1 & neckelshift=4.26 
endif 

  ; MgI+II.atom has only single levels so 1 line at wrong wavelength
if (linename eq 'MgIb1') then begin
  element='MG' &linewav=517.8 
  filelinename='MgIb1' &  pslinelabel='Mg I b!D1!N'
  wavrange=1 & addneckel=1 & neckelshift=5.463  
endif 

  ; 0 = line center; 2719 = blue peak ; 2715 = blue dip
if (linename eq 'MgIIk') then begin
  element='MG' & linewav=279.55
  filelinename='MgIIk' & pslinelabel='Mg II k'
  wavrange=10 & addneckel=0  & neckelshift=0
endif

if (linename eq 'MgIIh') then begin
  element='MG' & linewav=280.27 
  filelinename='MgIIh' & pslinelabel='Mg II h'
  wavrange=10 & addneckel=0  & neckelshift=0
endif 

; CaII lines
if (linename eq 'CaIIK') then begin
  element='CA' & linewav=393.366
  filelinename='CaIIK' & pslinelabel='Ca II K'
  wavrange=10 & addneckel=1  & neckelshift=0  
endif 

if (linename eq 'CaIIH') then begin
  element='CA' & linewav=396.6
  filelinename='CaIIH' & pslinelabel='Ca II H'
  wavrange=10 & addneckel=1 & neckelshift=0 
endif 

if (linename eq 'CaII8542') then begin
  element='CA' & linewav=854.209
  filelinename='CaII8542' & pslinelabel='Ca II 8542 '+string(197B)
  wavrange=10 & addneckel=1 & neckelshift=0   
endif 

; Na lines
if (linename eq 'NaID1') then begin
  element='NA' & linewav=589.594
  filelinename='NaID1' & pslinelabel='Na I D!D1!N'
  wavrange=10 & addneckel=1 & neckelshift=0   
endif 

;; commented out; needs usage of findline only after call of openpsplot
;; ; close ps dummy 
;; ;;closepsplot,'/tmp/psplotdummy.ps',opengv=0
;;   device,/close
;;   ; back to defaults
;;   set_plot,'X'          
;;   !p.font=-1            
;;   !p.thick=0 & !p.charthick=0 & !x.thick=0 & !y.thick=0

; get RH line stuff
nrtrans=0
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
thisatom=readatom('atom.'+element+'.out')
ntr=thisatom.nline+thisatom.ncont
for itr=0,ntr-1 do $
  if (abs(thisatom.transition[itr].lambda0-linewav) lt transinterval) $
  then begin
    wavlc=thisatom.transition[itr].lambda0
    tabinv,spectrum.lambda,wavlc,iwavlc
    itrans=itr
    nrtrans=nrtrans+1
    iwavlc=long(iwavlc+0.1)
    ilow=thisatom.transition[itr].i
    jupp=thisatom.transition[itr].j
    if (transprint) then print,text,element,itr,$
      ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
      format='(A43, A3, I5, I3, I3, I7, F9.3, F9.3)'
  ;RR how to spread format statement over multiple lines?
    ;; strwavlc=string(wavlc)
    ;; spawn,'grep
    ;; /home/rutten/rr/wrk/linetables/kurucz/gfall.dat'+strwavlc
  endif
if (nrtrans eq 0) then print,' ### FINDLINE.PRO: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### FINDLINE.PRO: multiple lines found'

if (thisatom.transition[itrans].shape eq 2) then PRD=1 else PRD=0

; set wavelength for the plots (0 for line center, iwav for other feature)
if (iwavsel eq 0) then begin 
  iwavplot=iwavlc & wavplot=wavlc 
endif else begin 
  iwavplot=iwavsel & wavplot=spectrum.lambda[iwavplot] 
endelse 

; end  ;; commented out for calling  @findline from a program



