; file: addhydpops2model.pro = add H populations to RH 1D atmos file 
; init: Aug 30 2015  Rob Rutten  Freiburg
; last: Aug 30 2015  Rob Rutten  Freiburg
; note: runrh on the new XXX_init.atmos without H pops (take them off) 
;       require hydrostatic equilibrium, have only H as active atom
;       select Halpha in local doinitline.pro
;       then in IDL session 
;         @doinitrh
;         @doinitline
;         .r addhydpops2model   ## after adapting filenames below

; ## adapt the two below file names for old and new .atmos files

infile='/home/rutten/rr/wrk/codes/rh/source_v2/Atmos/ALC7_BHEB_init.atmos'
outfile='/home/rutten/rr/wrk/codes/rh/source_v2/Atmos/ALC7_BHEB_noHSE.atmos'

; ## after this adapt filename by eg chfile _trial to the intended name

; =============== from here adaptation-free ===========================

;  below is largely a copy of Han Uitenbroek's write1datmos.pro

atmos=read1datmos(infile)  ; sets nhydr = 6 (default)

;RR stuff from Han write1datmos

CM_TO_M = 1.0E-2
KM_TO_M = 1.0E+3
G_TO_KG = 1.0E-3

; open output file = new RH .atmos file
openw, unit, outfile, /GET_LUN

; write the atmospheric model name
printf, unit, atmos.atmosID

; write the type of scale name
CASE (atmos.scale) OF
  'MASS_SCALE': printf, unit, FORMAT='(2X,"Mass scale")'
  'TAU500_SCALE': printf, unit, FORMAT='(2X,"Tau scale")'
  'GEOMETRIC_SCALE': FORMAT='(2X,"Height scale")'
ENDCASE

; write the lg g value
printf, unit, $
  FORMAT='("*",/"* lg g",/F6.2,/"*",/"* Ndep",/I4,/"*")', $
  alog10(atmos.gravitation), atmos.Ndep

; write the input atmos stratifications without any change
; RH wants only log m, temperature, N_e, macroscopic velocity = 0, microturb
; so even with new H populations including new n_p no change to n_e

CASE (atmos.scale) OF
  'MASS_SCALE': BEGIN
    printf, unit, $
      FORMAT='("*lg column mass", 5X,"Temperature",8X,"Ne",9X,"V",14X,"Vturb")'
    
    FOR k=0, atmos.Ndep-1 DO $
      printf, unit, FORMAT='(5E15.6)', $
      alog10(atmos.cmass[k] * CM_TO_M^2 / G_TO_KG), $
      atmos.T[k], atmos.n_elec[k] * CM_TO_M^3 , $
      atmos.v[k]/KM_TO_M, atmos.vturb[k]/KM_TO_M

  END
  'TAU500_SCALE': BEGIN
    printf, unit, $
      FORMAT='("*lg tau 500    ", 5X,"Temperature",8X,"Ne",9X,"V",14X,"Vturb")'
    
    FOR k=0, atmos.Ndep-1 DO $
      printf, unit, FORMAT='(5E15.6)', $
      alog10(atmos.tau500[k]), atmos.T[k], $
      atmos.n_elec[k] * CM_TO_M^3 , $
      atmos.v[k]/KM_TO_M, atmos.vturb[k]/KM_TO_M

  END
  'GEOMETRIC_SCALE': BEGIN
    printf, unit, $
      FORMAT='("*height [km]   ", 5X,"Temperature",8X,"Ne",9X,"V",14X,"Vturb")'

    FOR k=0, atmos.Ndep-1 DO $
      printf, unit, FORMAT='(E17.8, 4E15.6)', $
      atmos.height[k], atmos.T[k], atmos.n_elec[k] * CM_TO_M^3 , $
      atmos.v[k]/KM_TO_M, atmos.vturb[k]/KM_TO_M
  END
ENDCASE

;RR =============== now get the newly computed hydrogen pops

; this requires a run read in with #doinitrh and #doinitline asking Halpha

nlevels=thisatom.nlevel
hydpops=dblarr(nh,nlevels)
for ilevel=0,nlevels-1 do hydpops[*,ilevel]=(*thisatom.n_ptr)[*,ilevel] 

;; ;RR check above 
;; plot,heightkm,hydpops[*,0],/ylog
;; oplot,heightkm,hydpops[*,nlevels-1],linestyle=3
;; ; yes, OK, that is the proton density

; print header lines 
;RR  printf, unit, FORMAT='("*",/"* Hydrogen populations (LTE)")'
printf, unit, FORMAT='("*",/"* Hydrogen populations")'

printf, unit, FORMAT=$
  '("*",4X,"nh(1)",7X,"nh(2)",7X,"nh(3)",7X,"nh(4)",7X,"nh(5)",7X,"np")'

; now add the hydrogen pops; hydpops seems already to be nr/cm^-3
; note that RH is in KGSA units so m^-3 
; but the .atmos files are cm^-3 (as MULTI)
FOR idep=0, atmos.Ndep-1 DO begin $
  printf, unit, FORMAT='(6E12.4)', $
    hydpops[idep,0]* CM_TO_M^3,$
    hydpops[idep,1]* CM_TO_M^3,$
    hydpops[idep,2]* CM_TO_M^3,$
    hydpops[idep,3]* CM_TO_M^3,$
    hydpops[idep,4]* CM_TO_M^3,$
    hydpops[idep,nlevels-1]* CM_TO_M^3
endfor

free_lun, unit

END
