; file: template newstyle image production with openpsplot and closepsplot
; init: sometime 2103
; last: Apr 21 2018 

; image variables
imdata=data[201:500,351:500]>(800)<2000   ; FOV and clip selection
arcsecpx=0.071
sizeim=size(imdata)
nx=sizeim[1]
ny=sizeim[2]
xoffset=nxfull/2.-xrange[0]  ; nxfull, xcen from full fitsfile?  cut range?
yoffset=nyfull/2.-yrange[0]
xaxisarr=(indgen(nx)*float(nx)/(nx-1)-xoffset)*arcsecpx+xcen
yaxisarr=(indgen(ny)*float(ny)/(ny-1)-yoffset)*arcsecpx+ycen
axrat=(yaxisarr[ny-1]-yaxisarr[0])/(xaxisarr[nx-1]-xaxisarr[0])

; make image plot
psfilename='figfilename.ps'
plotarea=[0.2,0.2,0.95,0.95]
openpsplot,psfilename,thick=2,fontsize=7,xsize=8.8,ysize=8.8*axrat
!p.thick=0.2   ; thin curves
xtitle='x  [arcsec]'  ; define labels with Greek or AA after openpsplot
ytitle='y  [arcsec]'
tv,bytscl(imdata),plotarea[0],plotarea[1],$
  xsize=plotarea[2]-plotarea[0],ysize=plotarea[3]-plotarea[1],/normal
contour,imdata,xaxisarr,yaxisarr,$
  /nodata,/noerase,/xstyle,/ystyle,position=plotarea,$
  xticklen=-0.03,yticklen=-0.03*axrat,xtitle=xtitle,ytitle=ytitle

xyouts,0.32,0.32,/norm,charsize=1,color=255,'probeersel'  ; write overlay

closepsplot,psfilename,opengv=1
