; file: openpsplot.pro = ps open following my simple manual (~Alfred de Wijn)
; init: Feb 20 2011 
; last: Jul 26 2019  Rob Rutten  Deil
; note: needs recompilation after changes = .com openpsplot

;+

pro openpsplot,psfilename,$
  fontsize=fontsize,thick=thick,xsize=xsize,ysize=ysize,$
  xticklen=xticklen,yticklen=yticklen

 ; NAME:
 ;   openpsplot
 ; PURPOSE:
 ;   open a postscript file for plotting with default parameter choices
 ; CALL:
 ;   see above
 ; INPUTS:
 ;   psfilename (string)
 ; KEYWORDS:
 ;   fontsize = annotation size, default 9
 ;   thick = annotation thickness, default 2
 ;   xsize, ysize = plot size in cm, default 8.8, 1.618*8.8 (golden ratio)
 ;   xticklen = length major ticks x-axis, default 0.02
 ;   yticklen = length major ticks y-axis, default xticklen*xsize/ysize
 ; METHOD:
 ;   Google "Simple IDL manual"
 ; HISTORY:
 ;   Feb 20 2011: Rob Rutten, start
 ;   May 24 2016: Rob Rutten, improved this comment block
;-

if (n_params() lt 1) then begin
  print,' usage: openpsplot,psfilename,'
  print,'   [fontsize=fontsize,thick=thick,xsize=xsize,ysize=ysize,'
  print,'    xticklen=xticklen,yticklen=yticklen]'
  return     
endif  

if (n_elements(fontsize) eq 0) then fontsize=9   ; fit to publication
if (n_elements(thick) eq 0) then thick=2         ; choose thickness
if (n_elements(xsize) eq 0) then xsize=8.8       ; A&A column width cm
if (n_elements(ysize) eq 0) then ysize=xsize*2/(1+sqrt(5)) ; gold = 1.61803
if (n_elements(xticklen) eq 0) then xticklen=0.02
if (n_elements(yticklen) eq 0) then yticklen=xticklen*xsize/ysize

;; set_plot,'ps'  ;; ,/interpolate                                
set_plot,'ps'

; note: font either true-type or default Hershey
;       Hershey: use !5 at start first string for duplex Roman; is sticky
;!p.font=1   ; true-type fonts # taken out Oct 24 2012 for Yvonne 
;!p.font=-1  ; Hershey fonts
!p.font=2   ; mooier font dan 1 maar ik snap niet hoe

; note: charthick does not affect !p.font=1 true-type fonts
!p.thick=thick & !p.charthick=thick & !x.thick=thick & !y.thick=thick 
device,filename=psfilename,xsize=xsize,ysize=ysize,color=1,$
       /tt_font,font_size=fontsize,/portrait,bits_per_pixel=8,/encapsulated

end
