; file: closepsplot.pro = ps closure following simple manual (Alfred de Wijn)
; init: Feb 20 2011 
; last: Jun 28 2020  Rob Rutten  Deil

pro closepsplot,psfilename,opengv=opengv,crop=crop 

;+
 ; NAME:
 ;   closepsplot.pro  
 ; PURPOSE:
 ;   close a plot on the "ps device"
 ; CALL:
 ;   closepsplot,psfilename,opengv=opengv,crop=crop   
 ; INPUTS:
 ;   psfilename: string with path+filename, eg HRD.eps
 ; KEYWORDS:
 ;   opengv: mag/0 display the plot with ghostview (default yes @ mag=2)
 ;   crop: 1/0 remove white borders (default no)
 ; OUTPUTS:
 ;   graph in file (e)psfilename
 ; RESTRICTIONS:
 ;   none  
 ; METHOD:
 ;   Google "Simple IDL manual"
 ; HISTORY:
 ;   Feb 20 2011 RR: start
 ;   Jan 10 2014 RR: this info block
 ;   Dec  4 2014 RR: crop option
;-

  ; parameter checks 
if (n_params() lt 1) then begin
  print,' usage: closepsplot,psfilename,opengv=opengv,crop=crop'
  return
endif
if (n_elements(opengv) eq 0) then opengv=2 else opengv=opengv
if (n_elements(crop) eq 0) then crop=0 else crop=crop

  ; complete the plot
device,/close

  ; back to defaults
set_plot,'X'          
!p.font=-1            
!p.thick=0 & !p.charthick=0 & !x.thick=0 & !y.thick=0

; replace IDL banner by filename as title
spawn,'cat '+psfilename+$                             ; replace irritating
  '| sed "s|Graphics produced by IDL|'+psfilename+$   ; IDL plot banner
  '|" >  idltemp.ps; mv idltemp.ps '+psfilename       ; with the file name 

; crop option (but don't crop plots for multipanel figure)

if (crop eq 1) then begin
  spawn,'pscropepsone '+psfilename
  filenamesplit=strsplit(psfilename,".",/extract) 
  epsfilename=filenamesplit[0]+'.eps'
  spawn,'rm -f '+filenamesplit[0]+'.ps'
  if (opengv ne 0) then $
    spawn,'/usr/bin/gv -watch -scale='+trim(opengv)+' '+epsfilename+' &' 
endif else  $
  if (opengv ne 0) then $
    spawn,'/usr/bin/gv -watch -scale='+trim(opengv)+' '+psfilename+' &'

  ; done
if (crop) then print,' ----- closepsplot wrote '+epsfilename $
else  print,' ----- closepsplot wrote '+psfilename

end

