; file: alma_sdogong.pro
; init: Jan 12 2021  Rob Rutten  Deil
; last: Nov 19 2021  Rob Rutten  Deil
; note: UNDER (RE-)CONSTRUCTION 
; todo: time smearing to simulate formation delay ALMA-Halpha?

;+
pro alma_sdogong,px_alma,angle_alma,trimboxalma,$
  almafile=almafile,almataifile=almataifile,sdodir=sdodir,$
  itdelaygong=itdelaygong,itsmearalma=itsmearalma,itsmeargong=itsmeargong,$
  inshift12=inshift12,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  smearim1=smearim1,smearim2=smearim2,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,$
  show=show,blink=blink,verbose=verbose

 ; make ALMA cubefile fitting SDO target cubefiles including gongaia.fits
 ;
 ; INPUTS:
 ;  px_alma: arcsec
 ;  angle_alma: deg CCW, maybe solar p-angle eg pb0r('2018-12-25T17:20:55')
 ;  trimboxalma: trimbox in ALMA scene (showex almafile)
 ;
 ; KEYWORD INPUTS:
 ;   almafile: ALMA image sequence fitscube
 ;   almataifile: ALMA timing file per image in TAI
 ;
 ; OPTIONAL KEYWRD INPUTS:
 ;   sdo dir, default 'sdo', must have './target/cubes/almaaia.fits'
 ;   itdelaygong: take GONG-Halpha sample later (reasoning: Halpha fibrils
 ;     come after RBE heating) in units AIA dt=12s cadence
 ;   itsmearalma YET
 ;   itsmeargong YET
 ;   rest = keywords findalignimages.pro, im1=ha, im2=alma
 ;
 ; HISTORY:
 ;   Jan 12 2021 RR: written for CA ALMA data
 ;   Nov 13 2021 RR: adapted for TB ALMA data
;-

; answer no-parameter query 
if (n_params(0) ne 3) then begin
  sp,alma_sdogong
  return    
endif

; defaults for keywords
if (n_elements(sdodir) eq 0) then sdodir='sdo/'
if (n_elements(smearim1) eq 0) then smearim1=0
if (n_elements(smearim2) eq 0) then smearim2=0
if (n_elements(flatim1) eq 0) then flatim1=0
if (n_elements(flatim2) eq 0) then flatim2=0

; define output fitscube file
outfile=sdodir+'/target/cubes/almaaia.fits'

; build gongaia time array
fileha=sdodir+'/target/cubes/gongaia.fits' ; = copied AIA header = 171 timings
file304=sdodir+'/target/cubes/aia304.fits' ; trial 304 instead of Halpha
headha=headfits(fileha)
nt_ha=fxpar(headha,'naxis3')
starttim=fxpar(headha,'starttim')
cadence_ha=fxpar(headha,'cadence')
starttai=anytim2tai(starttim)
tai_ha=starttai+indgen(nt_ha)*cadence_ha

; find gongaia rms 
rms_ha=fltarr(nt_ha)
for itha=0,nt_ha-1 do begin
  imha=readfitscube(fileha,trange=[itha,itha])
  mom=moment(imha,sdev=sdev)
  rms_ha[itha]=sdev
endfor

; get tai_alma and find overlap SDO-ALMA timings
readcol,almataifile,tai_alma,format='D'
nt_alma=n_elements(tai_alma)
cadence_alma=(tai_alma[nt_alma-1]-tai_alma[0])/(nt_alma-1)
dummy=min(abs(tai_ha-tai_alma[0]),ithamin)
dummy=min(abs(tai_ha-tai_alma[nt_alma-1]),ithamax)

; find it max gongaia rms not exceeding itha+itdelaygong within gongaia range
maxharange=min([ithamax+itdelaygong,nt_ha-1])
dummy=max(rms_ha[ithamin+itdelaygong:maxharange],itmaxrms)
it_ha=itmaxrms+ithamin+itdelaygong

; find corresponding it ALMA
dummy=min(abs(tai_alma-tai_ha[it_ha-itdelaygong]),it_alma) 

; get images
imalma=readfitscube(almafile,trange=[it_alma,it_alma])

imha=readfitscube(fileha,trange=[it_ha,it_ha])
im304=readfitscube(file304,trange=[it_ha,it_ha])

; muck GONG Halpha
reformimage,imha,imharev,/intreverse    ;RR disk trick
imhamuck=imharev
imhamuck[where(imharev gt mean(imharev))]=$
  imha[where(imharev gt mean(imharev))]
;; showex,imhamuck,im304,/blink

; blink=1: show images instead of findalign 
if (blink eq 1) then begin

  ; show at equal actual scales
  ;; szalma=size(imalma)
  ;; window,1,xsize=szalma[1],ysize=szalma[2]
  ;; tvscl,imalma
  ;; congrid=[0.6/px_alma,0.6/px_alma]
  ;; reformimage,imhamuck,imhamucksc,congridfactor=congrid
  ;; szaia=size(imhamucksc)
  ;; window,2,xsize=szaia[1],ysize=szaia[2]
  ;; tvscl,imhamucksc
  ;; reformimage,im304,im304sc,congridfactor=congrid
  ;; window,3,xsize=szaia[1],ysize=szaia[2]
  ;; tvscl,im304sc

  ; show with center for measuring inshift12 and trimboxalma
  imalmacen=imalma
  szalma=size(imalma)
  imalmacen[szalma[1]/2-2:szalma[1]/2+2, $
            szalma[2]/2-2:szalma[2]/2+2]=max(imalma)
  showex,imalma,/markcenter,/noblock
  ;; sv,imalmacen
  ;; imhamuckcen=imhamuck
  ;; szmuck=size(imhamuck)
  ;; imhamuckcen[szmuck[1]/2-2:szmuck[1]/2+2, $
  ;;             szmuck[2]/2-2:szmuck[2]/2+2]=max(imhamuck)
  ;; sv,imhamuckcen
  showex,imhamuck,/markcenter
endif

; inputs for findalignimages
im1=imhamuck ; intensity-reversed GONG Halpha 
im2=imalma
px1=0.6     ; GONG redone on AIA px
px2=px_alma
angle=angle_alma
splinip=1            ; for comparing morphologies

; muck
if (smearim2 eq 0) then smearim2=smearim1*px1/px2
trimboxim2=trimboxalma
;; muckbrightim1=1.5
;; muckdarkim1=1.2
;; muckdarkim2=1.2
;; muckbrightim2=1.2

; run findalignimages (full call)
findalignimages,im1,im2,px1,px2,angle,px2asym,$
  shiftfor,shiftrev,nxfor,nyfor,nxrev,nyrev,$    
  nxmuckfor=nxmuckfor,nymuckfor=nymuckfor,$
  nxmuckrev=nxmuckrev,nymuckrev=nymuckrev,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,minmetqual=minmetqual,$
  applypx2asym=applypx2asym,$
  trimboxim2=trimboxim2,inshift12=inshift12,$
  smearim1=smearim1,smearim2=smearim2,$
  histopim1=histopim1,histopim2=histopim2,$
  muckdarkim1=muckdarkim1,muckdarkim2=muckdarkim2,$
  muckbrightim1=muckbrightim1,muckbrightim2=muckbrightim2,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  metqual=metqual,nmet=nmet,finalrinse=finalrinse,$
  blink=blink,show=show,verbose=verbose

; print findalignimages results 
if (verbose ne 0 and skipmetcalf eq 0) then print,' ----- results:'+$
  '  nmet ='+trimd(nmet)+$
  '  metqual = '+trim(metqual,'(E8.2)')+$
  '  angle ='+trimd(angle,2)+$
  '  px2 ='+trimd(px2,4)+$
  '  px2asym ='+trimd(px2asym,4)+$
  '  shiftfor ='+trimd(shiftfor,1)+$
  '  shiftrev ='+trimd(shiftrev,1)+$
  '  nxfor, nyfor ='+trimd([nxfor,nyfor])+$
  '  nxrev, nyrev ='+trimd([nxrev,nyrev])

; oops ALMA has smallest px but I don't want to rewrite and shift SDOs 
; as in my normal reverse mode using smallest px for shifts and rescale
szim1=size(im1)
nx_sdo=szim1[1]
ny_sdo=szim1[2]
if (px1 gt px2) then pxratio=[px2/px1,px2/px1] else pxratio=[1.,1.]

; write file ALMA in AIA target form
reformcubefile,almafile,outfile,$
  shift=shiftrev*pxratio,congridfactor=pxratio,rotate=-angle,$
  timearr_in=tai_alma,timearr_out=tai_ha,$
  nxlarge=nx_sdo,nylarge=ny_sdo,cutcentralx=nx_sdo,cutcentraly=ny_sdo,$
  missingvalue=-1,splinip=1

; showex result 
if (blink ne 1) then showex,/allsdo,sdodirs='sdo/target/cubes',$
  /plotscatter,/blink,frame_speed=4,wavindA=13,wavindB=14,/revA

end ; of program

; ==================================== run per Hyper/C

;; ; ==============  AC data done Jan 2021
;; cd,'/media/rutten/RRHOME/alldata/ALMA/2018-04-12-ca'

;; ; ALMA files
;; almafile='alma/alma3mm_grey.fits'
;; almataifile='alma/almatimestai.dat'

;; ; findalignimage inputs
;; px_alma=0.51
;; angle_alma=-25.56
;; trimboxalma=[60,50,206,201] ; within circular FOV aperture
;; inshift12=[-12.3,11.2]
;; itdelaygong=15  ; 3 min delay

; =========== TB limb data Nov 2021
cd,'/home/rutten/data/ALMA/2018-12-25-tb-image'

; ALMA files
almafile='alma/almacube.fits'
almataifile='alma/almatai.dat'

; findalignimage inputs
px_alma=0.2 ; Tim email
;; angle_alma=+5.235 ; rotate CCW over solar p angle to put ALMA on AIA
;; check: print,pb0r('2018-12-25T17:20:55') => +5.234 
angle_alma=0.0  ; after rotate in image2cube.idl

; muck choices
inshift12=[30,10]
trimboxalma=-1
trimboxalma=[28,48,316,233] ; after rotate in image2cube.idl
;; trimboxalma=[30,39,316,100] ; after rotate in image2cube.idl
smearim1=0 ; GONG or 304
smearim2=0 ; ALMA 
flatten=0 ; oops, px1 but px2 3x smaller and trimbox in px 2
flatim1=0
flatim2=0

itdelaygong=0    ; min delay sample Halpha after ALMA, units AIA dt=12s
skipmetcalf=1   ; no solving for px and angle
maxmetcalf=0    ; idem

; output choices
blink=30
show=0
verbose=1

; full call (copy-paste from start)
alma_sdogong,px_alma,angle_alma,trimboxalma,$
  almafile=almafile,almataifile=almataifile,sdodir=sdodir,$
  itdelaygong=itdelaygong,itsmearalma=itsmearalma,itsmeargong=itsmeargong,$
  inshift12=inshift12,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  smearim1=smearim1,smearim2=smearim2,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,$
  show=show,blink=blink,verbose=verbose

end
 
