; file: wav2freq.pro
; init: May 22 2017  Rob Rutten  Lent
; last: May 22 2017  Rob Rutten  Lent

;+

function wav2freq,wav

 ; convert wavelength in mm to frequency in Hz
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
    print,' wav2freq, wav [mm]'
    return,-1
endif

ccgs=2.99792458D10       ; velocity of light (cm/s)
wavaa=wav*1.E3*1.E4      ; mm > micron > AA
airtovac,wavaa,vacaa     ; air > vacuum
vacmm=vacaa*1.E-3*1.E-4  ; AA > mm
freq=ccgs*10./vacmm

; add nice printout
if (freq gt 1.E12) then $
  print,' ----- '+trimd(wav)+' mm = '+trimd(freq/1.E12)+' Thz' $
  else if (freq gt 1.E9) then $
  print,' ----- '+trimd(wav)+' mm = '+trimd(freq/1.E9)+' Ghz' $
  else if (freq gt 1.E6) then $
  print,' ----- '+trimd(wav)+' mm = '+trimd(freq/1.E6)+' Mhz' $
  else if (freq gt 1.E3) then $
  print,' ----- '+trimd(wav)+' mm = '+trimd(freq/1.E3)+' khz'

return,freq
end

; ------------------------------- test

freq=wav2freq(1.3)
end
