; file: trimd.pro = wrapper to trim.pro for nice number printing
; init: May  6 2017  Rob Rutten  Deil
; last: Aug  7 2020  Rob Rutten  Deil

;+

function trimd,var,ndec,nospace=nospace,addplus=addplus

 ; NAME:
 ;   trimd
 ;   
 ; PURPOSE:
 ;   nicely print number per trim, limit decimals, add leading space
 ;   
 ; INPUTS:
 ;   var = variable = integer, float, double, 1D array  
 ;
 ; OPTIONAL INPUTS:
 ;   ndec = number of decimals (default 3, max 6)
 ;   addplus = 1/0: add plus before when positive
 ;   keyword nospace=1/0: no leading space added (default 0 = add)
 ;
 ; OUTPUT:
 ;   string to print   
 ;   
 ; HISTORY:
 ;   May  9 2017 Rob Rutten  
 ;   Dec 24 2017 RR: check NaN
 ;   Jun  3 2019 RR: nospace
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,trimd
  return, -1
endif

; default ndec
if (n_params() eq 1) then ndec=3

; default keywords
if (n_elements(nospace) eq 0) then nospace=0
if (n_elements(addplus) eq 0) then addplus=0

; set space
if (nospace) then space='' else space=' '

; limit ndec
if (ndec gt 6) then ndec=6

; get var type and size
sz=size(var)
nelsz=n_elements(sz)
type=sz[nelsz-2]

; set plus (only for single number)
if (addplus and sz[0] eq 0 and var[0] gt 0) then plus='+' else plus='' 

; loop for when var is 1D array
trimd=''
nloop=0
if (sz[0] eq 1) then nloop=sz[1]-1
for ivar=0,nloop do begin

; integer
  if (type eq 2 or type eq 3 or type ge 12) then $
    trimd=trimd+space+plus+trim(var[ivar])

; float
  if (type eq 4) then begin
    if (finite(var[ivar]) eq 0) then trimd=trimd+space+'NaN' else $
    if (abs(var[ivar]) gt 1.E5 or abs(var[ivar]) lt 1D1^(fix(-ndec/2-1))) $
    then begin
      trimd=trimd+space+plus+trim(var[ivar],'(E30.'+trim(ndec)+')')
    endif else begin
      signvar=sign(1,var[ivar])     ;RR trick from Paul Hick of all people
      varcut=signvar*abs(double(fix(var[ivar]*1.D1^ndec+0.5,type=14)$
      /1.D1^ndec))
      trimd=trimd+space+plus+trim(varcut,'(F30.'+trim(ndec)+')')
    endelse
  endif
  
; double
  if  (type eq 5) then $
    trimd=trimd+space+plus+trim(var[ivar],'(D30.'+trim(ndec)+')')

endfor

return,trimd
end


; =============== main for testing per IDLWAVE H-c ======================

ndec=3  ;RR undo stickiness in reruns within session

x=100000                    ; long integer
x=0.0000123456789E0
x=-20.123456789
x=-1234567890.9876543210D0  ; double
x=1.234
x=0.031

;; x=0.0005
;; x=1
;; x=1.00000000

print,' ----- triple ='+trimd([x,x,x],1)
print,' ----- one ='+trimd(x,1,/nospace,/addplus)

end

