; file: splinapp_get.pro
; init: Apr 18 2016  Rob Rutten  Oslo
; last: Nov  5 2018  Rob Rutten  Deil

;+

function splinapp_get,x0,x,a,b,c,d 

 ; NAME:
 ;   see above
 ;   
 ; PURPOSE:
 ;   evaluate a cubic spline appromimation set up by splinapp_set.pro
 ;   
 ; DESCRIPTION:
 ;   based on splinapp_nv.pro by Nilola Vitas under rridl/collib
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   x0: abscissa(e) at which to evaluate spline (array permitted)
 ;   x: input abscissae in preceding call splinapp_set.pro
 ;   a,b,c,d: output coefficient arrays at x values from splinapp_set.pro
 ;
 ; HISTORY:
 ;   Apr 18 2016 RR: start = excerpt from splinapp_nv.pro
 ;   Nov  5 2018 RR: permit array input, extrapolate along spline
;-

; start
n=n_elements(x)-1   ;RR this is for counting up to n
nx0=n_elements(x0)  ;RR permit array input/output 
y0=fltarr(nx0)

; evaluate spline at x0 value(s)
for ix0=0,nx0-1 do begin
  for ix=1,n-1 do begin    ;RR corrected this and line above Jul 29 2018 
    indx=ix
    if (x0[ix0] lt x[ix+1]) then break 
  endfor
  y0[ix0]=d[indx]+c[indx]*(x0[ix0]-x[indx])+b[indx]*(x0[ix0]-x[indx])^2 $
    +a[indx]*(x0[ix0]-x[indx])^3 
endfor 

return,y0
end


; ================= test per IDLWAVE Hyper-C =========================

np=11  ; = 0 - 100
x=indgen(np)*10.
y=x+randomn(1,np)*10.+10
y[0]=y[0]+20.   ; add uptilt
y[np-1]=y[np-1]-20.  ; add downtilt

plot,x,y,psym=-4,xrange=[-20,120],/xstyle,yrange=[-10,130],/ystyle

splinapp_set,x,y,a,b,c,d,smooth=200

fit=fltarr(np+2)
xsample=indgen(np+2)*10.-10.
fit=splinapp_get(xsample,x,a,b,c,d)

oplot,xsample,fit,psym=-5,linestyle=2

end

