; sp.pro = show IDL pro comment header in separate window
; init: Oct 11 2013  Rob Rutten
; last: Nov 11 2020  Rob Rutten  Deil
; site: rridl/misclib

;+
pro sp,proname
 ;
 ; "show program": show ;+...;- comment block in IDL procedure or function 
 ;
 ; INPUT:
 ;   proname (without string quotes and without .pro, eg idl> sp,sp)
 ;
 ; OUTPUT:
 ;   gedit editor window with comment block between ;+ and ;- lines
 ;
 ; RESTRICTIONS:
 ;   if gedit doesn't exist install it or change sp.pro to another editor
 ;
 ; USAGE:
 ;   check program description by entering its name without parameters
 ;
 ; HISTORY:
 ;   Oct 11 2013 RR: start, using gedit
 ;   Oct 13 2013 RR: added this comment block for self-explanation
 ;   Jun  7 2014 RR: for Ubuntu 14.04 took out gedit -b option
 ;   Nov 11 2020 RR: print error message
;-

; treat proname
varname=SCOPE_VARNAME(proname,level=-1)  ; get proname as string (f**k IDL)
lowvarname=strlowcase(varname)           ; IDL has it in caps

; error flag and explanation
print,' ##### if you did not call "sp,'+lowvarname+'" yourself then your call'
print,'       of '+lowvarname+'.pro has the wrong number of parameters or'
print,'       wrong parameters or used wrong quotes (not straight-up single).'
print,'       Now rridl/misclib/sp.pro ("show program") tries to spawn'
print,'       gedit opening the start-off comment block in a new window.'
print,'       If no gedit present replace this by another editor in sp.pro?'
print,'       The top gedit line shows where your '+lowvarname+'.pro resides,'
print,'       or which one gets loaded by IDL when there are more.'

;  compile it to make sure IDL sees it as pro, not function (f**k IDL)
forward_function varname

; get the initial comment block between ;+ and ;-
doc_library, varname, print='cat > /tmp/'+lowvarname+'.pro'

; spawm into a new window opening the comment block in gedit
spawn,'if (-e /tmp/'+lowvarname+'.pro) gedit /tmp/'+lowvarname+'.pro &'
  
end

; =================== run as main per IDLWAVE Hyper-C

sp,sp

end
