; file: solrotcomp.pro = print table of rotation compensation X,Y resettings
; init: Apr 16 2009 Deil  what was this for?  
; last: May 24 2018  Rob Rutten  Deil


pro solrotcomp, tstart, xstart, ystart
; produce a table of solar rotation-compensated solar (X,Y) settings

interval=2.*3600. ; 2 hours in seconds
tstarttai=anytim2tai(tstart)
for it=-24,24 do begin
  tendtai=tstarttai+it*interval
  tend=anytim2utc(tendtai,/ccsds)
  rotxy=rot_xy(xstart,ystart,tstart=tstart,tend=tend)

  print,'      ',tend+'   X= '+trimd(rotxy[0])+$
   '   Y='+trimd(rotxy[1])+'  arcsec'
endfor

end

; ============= run per Hyper C =================

dtstart='2014-06-21 08:00'
xstart=-206
ystart=+210
solrotcomp, dtstart, xstart, ystart

end
