; file: rotatevec.pro
; init: May  5 2017  Rob Rutten  Deil
; last: Jun  1 2017  Rob Rutten  Deil

;+

function rotatevec,invec,angle

 ; NAME:
 ;   rotatevec.pro
 ;   
 ; PURPOSE:
 ;   rotate a vector
 ;   
 ; DESCRIPTION:
 ;    https://en.wikipedia.org/wiki/Rotation_matrix 
 ;   
 ; CALL:
 ;   see example at end of this file
 ;   
 ; INPUTS:
 ;   invec = 2-elem vector [x,y] or [N,2] array (e.g., time sequence)
 ;   angle = angle in degrees over which to rotate
 ;           positive = counterclockwise
 ;   
 ; OUTPUTS:
 ;   [[xrot],[yrot]]
 ;   
 ; HISTORY:
 ;   May  5 2017 RR: x,y single 2-elem vector
 ;   Jun  1 2017 RR: invec may be [N,2] array
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
    print,'vecrot=rotatevec(invec,angle)'
    sp,rotatevec
    return,-1
endif

; check dimensions
sizevec=size(invec)
if (not(sizevec[0] eq 1 or (sizevec[0] eq 2 and sizevec[2] eq 2))) then begin
  print,' ##### rotatevec abort: invec is not 2-elem or (N,2) array'
  sp,rotatevec
  return,-1
endif

; get rotated vector
theta=angle*!pi/180.
if (sizevec[0] eq 1) then begin
  x=invec[0]
  y=invec[1]
endif else begin
  x=invec[*,0]
  y=invec[*,1]
endelse
xrot=x*cos(theta)-y*sin(theta)
yrot=x*sin(theta)+y*cos(theta)
return,reform([[xrot],[yrot]])
end


; =============== main for testing per IDLWAVE H-c ======================

invec=[1,1]
;; xvec=[1,2,3]
;; yvec=[1,2,3]
;; invec=[[xvec],[yvec]]
angle=45.
result=rotatevec(invec,angle)
help,result
print,result

end
