; file: printmu.pro
; last: Jul 31 2018  Rob Rutten  Deil
; note: from Gregal Vissers

PRO printmu, xy, date=date

;+
 ; NAME:
 ;   printmu 
 ; PURPOSE:
 ;   print solar theta and mu values for given (X,Y) and date
 ; CALL:
 ;   printmu, xy, date=date
 ;     e.g: printmu,[100,100],date='2011 Oct 25'
 ; INPUTS:
 ;   xy = 2-element array [X,Y]
 ;   date = date in CDS format eg '2011-10-25'
 ; OUTPUTS:
 ;   printed values of viewing angle theta and mu 
 ; HISTORY:
 ;  2011 May 19 Gregal Vissers: start
 ;  2011 Oct 25 Gregal Vissers
 ;  Nov  6 2014 RR: added theta, this comment block
 ;  Feb 28 2016 RR: added projfac = cos(90-theta)
 ;  Jul 31 2018 RR: took out funny date format: gave big error  
;-

; answer no-parameter query
if (n_params() lt 1) then begin
  sp,printmu
  return
endif

IF (N_ELEMENTS(DATE) NE 1) THEN BEGIN
;RR OOPS Jul 31 2018: I had big trouble with the below
  months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
  tstr = STRSPLIT(SYSTIME(),' ',/EXTRACT)
  yyyy = tstr[4]
  mm = STRING(WHERE(months EQ tstr[1])+1,FORMAT='(I02)')
  dd = tstr[2]
  seldate = yyyy+'-'+mm+'-'+dd
ENDIF ELSE seldate = date

r_sun = (PB0R(seldate, /ARCSEC))[2]
PRINT,'Solar radius on '+seldate+': '+STRTRIM(r_sun,2)
IF (N_ELEMENTS(XY) EQ 2) THEN BEGIN
  dblxy=double(xy)
  rho = SQRT(FLOAT(dblxy[0])^2 + FLOAT(dblxy[1])^2)
  mu_val = SQRT(1 - (rho/r_sun)^2)
  theta=180./!pi*acos(mu_val)
  PRINT,'Input coordinates are (x,y)=('+STRTRIM(xy[0],2)+','+$
     STRTRIM(xy[1],2)+')'
  PRINT,'theta: '+ntostr(theta)+'  mu: '+ntostr(mu_val)+$
    '  projfac: '+ntostr(cos((90-theta)*!pi/180.))+$
    '  r/R_sun: '+ntostr(rho/r_sun)
ENDIF
END

; =========================== test per H-c =========================

;; date='2018 Jan 01' ; OOPS OOPS this format gave big error....
date='2018-01-01'
xy=[0,1551*0.6]
printmu,xy,date=date

end
