; file: normgauss.pro = get value of area-normalized Gauss
; init: Feb  2 2021  Rob Rutten  Deil
; last: Feb  2 2021  Rob Rutten  Deil
; note: https://en.wikipedia.org/wiki/Gaussian_function ## why not in IDL?

;+
function normgauss,dx,fwhm
 ; 
 ; compute value of area-normalized Gauss with FHWM at dx from center
 ;
 ; INPUTS:
 ;  dx = distance from center in x-axis units   
 ;  fwhm = FWHM in the same units 
 ;   
 ; OUTPUTS:
 ;  area-normalized Gauss value    
 ;   
 ; HISTORY:
 ;   Feb  2 2021 RR: for GONG-like Halpha profile integration
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  sp,normgauss
  return,-1
endif

c=fwhm/2.35482
gauss=(1./(c*sqrt(2*!pi)))*exp(-dx^2/(2*c^2))
return,gauss
end


; =============== main for testing per IDLWAVE H-c ======================

dx=indgen(100)-50
gauss=fltarr(100)
fwhm=40
center=normgauss(0,fwhm)
help,center
for ix=0,100-1 do gauss[ix]=normgauss(dx[ix],fwhm)
help,gauss
plot,dx,gauss
print,total(gauss)
end
