; file: getdirpath.pro
; init: Jan  4 2018  Rob Rutten  Deil
; last: Jan  4 2018  Rob Rutten  Deil

;+

function getdirpath,filestring

 ; NAME:
 ;   getdirpath   
 ;   
 ; PURPOSE:
 ;   given file in subdir of current working dir, get full filepath 
 ;   
 ; DESCRIPTION:
 ;   bloody IDL, needlessly cumbersome
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUT:
 ;   filestring = local dirpath+filename
 ;   
 ; OUTPUT:
 ;   full dirpath   
 ;   
 ; HISTORY:
 ;   Jan  4 2018 RR: start 
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,getdirpath
  return,-1
endif

cd,current=thisdir
thisdir=strjoin(strsplit(thisdir,' ',/extract),'\ ')  ;RR bloody Mac's
dirpath=filepath(filestring,root=thisdir)
lastslash=strpos(dirpath,'/',/reverse_search)
dirpath=strmid(dirpath,0,lastslash+1) ;RR f##k IDL, why so complex?

return,dirpath

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SST/2016-09-05-demo/' 
filestring='sdo/target/cubes/hmicont.fits'
dirpath=getdirpath(filestring)
print,dirpath

end
