; file: freq2wav.pro.pro
; init: May 22 2017  Rob Rutten  Lent
; last: May 22 2017  Rob Rutten  Lent

;+

function freq2wav,freq

 ; convert frequency in Hz to wavelength in mm 
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
    print,' freq2wav, freq [Hz]'
    return,-1
endif

ccgs=2.99792458D10                 ; velocity of light (cm/s)
vacwavaa=1.E4*1.E3*1.E1*ccgs/freq  ; cm > mm > micron > AA
vactoair,vacwavaa,wavaa            ; vacuum > air
wavmm=wavaa*1.E-3*1.E-4            ; AA > mm

; add nice printout
if (wavmm le 1.E-4) then $
  print,' ----- '+trimd(freq)+' Hz = '+trimd(wavmm*1.E7)+' AA' $
  else if (wavmm le 1) then $
  print,' ----- '+trimd( freq)+' Hz = '+trimd(wavmm*1.E3)+' micron' $
  else if (wavmm le 1.E3) then $
  print,' ----- '+trimd(freq)+' Hz = '+trimd(wavmm)+' mm' $
  else if (wavmm le 1.E6) then $
  print,' ----- '+trimd(freq)+' Hz = '+trimd(wavmm*1.E-3)+' m'

return,wavmm
end

; --------------------------- test 

wavmm=freq2wav(230.551E9)   ; 1.3 mm (ALMA)

end
