; file: findwidgetfont.pro
; init: Dec 24 2018  Rob Rutten  Deil
; last: Dec 25 2018  Rob Rutten  Deil
; from: http://www.idlcoyote.com/widget_tips/defaultfont.html

FUNCTION findwidgetfont, DEFAULT=default     

       ; Build a small widget to determine the current 
       ; and default widget fonts.
       base = Widget_Base(MAP=0)
       button = Widget_Button(base, Value='TEST')        

       ; Checking before realization gives default font.
       defaultFont = Widget_Info(button, /FONTNAME)        

       ; Checking after realization gives current font.
       Widget_Control, base, /REALIZE
       currentFont = Widget_Info(button, /FONTNAME)

       ; Clean up.
       Widget_Control, base, /DESTROY

       IF Keyword_Set(default) THEN $
         RETURN, defaultFont ELSE $
           RETURN, currentFont         
    END 

; ------------ run per Hyper-C

print,findwidgetfont()

; my IDL default under Ubuntu is
;   -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO8859-1
; as for coyote's linux.  Linux command xlsfonts shows full font list.
; Too small for movex.pro buttons in my Tosh4 = 1920x1080 in 13.3 inch screen

end
