; file: denanarray.pro = replace NaNs in an array
; init: Nov  9 2021  Rob Rutten  Deil 
; last: Nov  9 2021  Rob Rutten  Deil

;+
pro denanarray,array,replace=replace,verbose=verbose

 ;
 ; INPUTS: 
 ;   array: 1D, 2D, 3D array any type, gets replaced by NaN-cleaned
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   replace: value to replace NaNs with, default zero
 ;   verbose 1/0: print numbers NaN and no-NaN elements
 ;
 ; OUTPUTS:
 ;   same array but with the NaN replacements
 ;   
 ; HISTORY:
 ;   Nov  9 2021 RR: upon getting ALMA image with NaN border
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,denanarray
  return
endif

; defaults for keywords
if (n_elements(replace) eq 0) then replace=0
if (n_elements(verbose) eq 0) then verbose=0

; find NaNs and replace them
nonans=where(finite(array) eq 1) ; goodies
nans=where(finite(array) eq 0)   ; baddies
array[nans]=replace ; set NaNs zero or replace

; optional printout
if (verbose) then $
  print,' ----- nr NaN ='+trimd(n_elements(nans)),$
        '   nr not-Nan ='+trimd(n_elements(nonans)) 
end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/Dropbox/ALMA-Spicules/alma'
almaim=readfits('M6_01_rw_P2a.fits')
denanarray,almaim,/verbose
sv,almaim

end
