; file: bytzero.pro = bytscale maintaining zero
; init: Mar  4 2015  Rob Rutten  Deil
; last: Aug 14 2020  Rob Rutten  Deil

;+
function bytzero,data,min=min,max=max

 ; bytscale image array or movie cube maintaining the zero value
 ; for Dopplergrams and magnetograms
 ; CALL:
 ;  scaleddata=bytzero(data,min=min,max=max)  
 ; INPUTS:
 ;   data: array of any type or size
 ; OPTIONAL KEYWORD INPUTS
 ;   min, max: as in bytscl.  The largest (absolute) is used. 
 ; HISTORY:
 ;   Mar  4 2015 RR: start 
;-

; answer no-parameter query
if (n_params() lt 1) then begin
   print,' scaleddata=bytzero(data,min=min,max=max)'
   return,-1
 endif

if (not keyword_set(min)) then mindat=min(data) else mindat=min
if (not keyword_set(max)) then maxdat=max(data) else maxdat=max
if (mindat gt 0) then print,' #### bytzero: min not negative'
if (-mindat gt maxdat) then maxdat=-mindat else mindat=-maxdat
scaleddat=bytscl(data,max=maxdat,min=mindat)  
return,scaleddat
end

; ================== test per hyper C =========================

mag=readfitscube('/home/rutten/data/SDO/2014-01-10-test/cubes/hmimag.fits',$
  trange=[0,0])
mag=mag<500  ; artificial cut, positive area must get grey
scalemag=bytzero(mag)

; inspect
szmag=size(mag)
window,0,xpos=100,ypos=100,xsize=szmag[1],ysize=szmag[2]
tvscl,mag
window,1,xpos=100,ypos=130+szmag[2],xsize=szmag[1],ysize=szmag[2]
tv,scalemag

end
