; file aa2exccm1.pro
; init: Nov 11 2016  Rob Rutten  Deil
; last: Nov 11 2016  Rob Rutten  Deil

function aa2exccm1,wavaa

;+
; converts (air) wavelength in AA to excitation energy difference in cm^-1
; history: Nov 11 2016 Rob Rutten
;-

@constants_cgs.idl
airtovac,wavaa,vacaa
return,hcgs*ccgs/(vacaa/1.E8)/ergpercmwav
end

; ==================== test Hyper-C ==============

print, 61671.020-aa2exccm1(2514.)  ; MgI edge 1st excited level
print, 61671.020-aa2exccm1(1622.)  ; MgI edge ground state


end
