; writeabundances.pro = write file abundances.dat for rrabundance answerer
; init: Jun 14 2016  Rob Rutten  Deil
; last: Jun 15 2016  Rob Rutten  Deil

;; pro dummy ; for formatting

; read atomic data
atomdata_wsa,indgen(92)+1,wgt,abu,ei1,ei2,ei3,sym 

; open file
openw,abufile,'rridl/ltelib/abundances.dat',/get_lun

; print header
printf,abufile,'nr el  logA12  Nel/NH     ion1eV wav1AA  ion2eV  wav2AA  ion3eV  wav3AA'

; print one line per element
for i=0,91 do printf,abufile,$
  string(i+1,format='(I3)')+$
  string(sym[i],format='(a3)')+$
  string(alog10(abu[i])+12,format='(F7.2)')+$
  string(abu[i],format='(E10.2)')+$
  string(ei1[i],format='(F9.3)')+$
  string(vacuumtoair(1.239842E3/ei1[i])*10.,format='(F7.1)')+$
  string(ei2[i],format='(F9.3)')+$ 
  string(vacuumtoair(1.239842E3/ei2[i])*10.,format='(F7.1)')+$
  string(ei3[i],format='(F9.3)')+$ 
  string(vacuumtoair(1.239842E3/ei3[i])*10.,format='(F7.1)')

; done
close,abufile
end 

; ========= run per IDLWAVE Hyper-c ==================
