; file: saha_wsa.pro
; last: Mar 28 2015  Rob Rutten  Deil

function saha_wsa,t,pe,ul,uu,chi	

;+
; PURPOSE:
;  compute the ionization equilibrium between two ionizations states
;  according to the Saha equation.
;
; INPUT:
;	t 	temperature (k) (number or array)
;	pe	electron pressure (dny/cm2)   (number or array)
;	ul	partition function for the ionization l  (number or array)
;	uu	partition function for the ionization l+1  (number or array)
;	chi	ionization energy  from l to u (ev) (number)
;	
; OUTPUT:
;	saha_wsa = ratio number of ions in l+1 / number in ion (atom) l
; 
; MODIFICATION HISTORY:
;   Sometime: coming from sos (fortran)
;   Aug 31 1995 Jorge Sanchez Almeida: conversion to IDL
;   Sep 17 2013 RR: cosmetics
;-

	const=.6665*uu/ul
	c1=-5040.*chi

; let's go
	saha_wsa=const*t^2.5*10.^(c1/t)/pe
;
	return,saha_wsa
	end
