; file: saha_mc.pro = compute Saha fractions for two successive stages
; note: taken from the MULTI lib of Mats Carlsson
; last: Sep 16 2013  Rob Rutten, Deil = changed name

pro saha_mc,t,nne,xi,u0,u1,n1_ntot,n0_ntot

;+
;   saha,t,nne,xi,u0,u1,n1_ntot,n0_ntot
;            calculates saha ionization fractions 
;            parameters:
;            t      temperature K
;            nne    electron density
;            xi     ionization potential (eV)
;            u0     partition function of neutral element
;            u1     partition function of ionized element
;            n1_ntot output: ionization fraction
;            n0_ntot output: neutral fraction
;            all atoms are supposed to be either neutral or once ionized
;-

if (n_params(0) lt 7) then begin
  print,'saha,t,nne,xi,u0,u1,n1_ntot,n0_ntot'
  return
endif
bk= 1.38066E-16         ;RR changed to double precision
theta=5039.77D0/t       ;RR changed to double precision
phit=0.6665D0*u1/u0*t^2.5*10.^(-theta*xi)       ; function phi of Gray
n1_n0=phit/(nne*bk*t)                           ; N1/N0
n1_ntot=n1_n0/(1.+n1_n0)
n0_ntot=1/(1.+n1_n0)
end


