; file: read_line_params.pro = get atomic parameters for a Fraunhofer line
; init: Sep 30 2013  Rob Rutten
; last: Nov  4 2015  Rob Rutten  Deil

pro read_line_params,thisline,linewav,elemnr,ionstage,excerg,$
  glow,gup,llow,lup,gfval,logc4,ident

;+  
; call:   read_line_params,thisline,linewav,elemnr,ionstage,excerg,$
;                  glow,gup,llow,lup,gfval,logc4,ident
; input:  thisline in Angstrom to select a line (within 1 AA)
; output: the others, read from table in file line_params.dat 
;-

if (n_params(0) lt 10) then begin
  print,'read_line_params,thisline,linewav,elemnr,ionstage,excerg,$'
  print,'               glow,gup,llow,lup,gfval,logc4,ident'
  print,' thisline = air wavelength in AA within 1 AA of actual line'
  return
endif

; read the line table
lineparamfile='rridl/ltelib/line_params.dat'
lineparamstruct={linewav:0.0,elemnr:0,ionstage:0,excerg:0.0,$
                 glow:0,gup:0,llow:0,lup:0,gfval:0.0,logc4:0.0,$
                 ident:'ABCDEFG'}
read_struct,lineparamfile,lineparamstruct,lineparams,$
  skiplines=10,/silent

; find our line
nlines=size(lineparams.linewav,/n_elements)
for iline=0,nlines do begin 
  if (iline eq nlines) then begin
    print,' ##### read_line_params abort: no such line = ',ntostr(thisline)
    return
  endif
  if (abs(lineparams[iline].linewav-thisline) lt 1.) then break
endfor

; assign values
linewav=lineparams[iline].linewav
elemnr=lineparams[iline].elemnr
ionstage=lineparams[iline].ionstage
excerg=lineparams[iline].excerg
glow=lineparams[iline].glow
gup=lineparams[iline].gup
llow=lineparams[iline].llow
lup=lineparams[iline].lup
gfval=lineparams[iline].gfval
logc4=lineparams[iline].logc4
ident=lineparams[iline].ident

end

; ================ main for IDLWAVE H-c tests ===========================

read_line_params,6563.,linewav,elemnr,ionstage,excerg,glow,gup,llow,lup,$
                        gfval,logc4,ident
print,ident,ntostr([linewav,elemnr,ionstage,excerg,glow,gup,llow,lup,gfval,logc4])

end
