; file: planck_micron.pro
; init: long ago
; last: Jul 11 2016  Rob Rutten  Deil

;+

function planck_micron,temp,wav

 ; NAME:
 ;   planck_micron.pro
 ; PURPOSE:
 ;   compute Planck function with bandpass unit = 1 micron
 ; CALL:
 ;   see above
 ; INPUTS:
 ;    temp = temperature (K)        ; may be array
 ;    wav = wavelength in micron    ; may be array; equal if both array
 ; OUTPUT:
 ;    Planck function in units:
 ;      Joule / m^2 sec [delta lambda = 1 micron] steradian
 ;      = Watt / m^2 [delta lambda = 1 micron] steradian
 ; HISTORY:
 ;   1991 or so  RR: for SSA exercises
 ;   Oct 15 2013 RR: this comment block
;-

; physics constants in cgs (all cm)
k=1.380658D-16        ; Boltzmann constant (erg K; double precision)
h=6.626076D-27        ; Planck constant (erg s)
c=2.997929D10          ; velocity of light (cm/s)

; units
wavcm=wav*1.E-4        ; change wav into cm
blambda = 2*h*c^2/(wavcm^5*(exp(h*c/(wavcm*k*temp))-1))
   ; cgs: in erg / cm2 sec [delta lambda=1 cm] ster
blambda=blambda*1E-4  ; delta lambda from per cm to per micron
blambda=blambda*1E-7  ; from ergs to Joule
blambda=blambda*1E4   ; from /cm2 to /m2

return,blambda
end

; ============= test per IDLWAVE Hyper-C ==============

; test b_u/b_l Wien sensitivity 
temp=[5100,4400,5300,6700]
temp=[4800,4400,5000,6700]
wav=0.364
 val=planck_micron(temp,wav)
print,alog10(val[0]/val[1])
print,alog10(val[2]/val[3])

end
