; file: planck_cm.pro = Planck function, cgs, wavelength+bandwidth cm
; last: Nov 14 2001 

;+
function planck_cm,temp,wav
  ; in:  temp = temperature (K)
  ;      wav = wavelength in cm  (1cm = 10^8 Angstrom)
  ; out: Planck function in cgs: erg / cm2 sec [delta lambda=1cm] ster
;-

; physics constants
k=1.380658D-16        ; Boltzmann constant (erg K; double precision)
h=6.626076D-27        ; Planck constant (erg s)
c=2.997929D10         ; velocity of light (cm/s)

blambda = 2*h*c^2/(wav^5*(exp(h*c/(wav*k*temp))-1))    ; cgs units
return,blambda
end

; ============== run per IDLWAVE Hyper-C ================================

temp=5000.
wavAA=5000.
wavcm=wavAA*1.E-8
wavmu=wavAA/1.E4
Bcm=planck_cm(temp,wavcm)
Bmu=Bcm/1.E4

Tb=brighttemp(wavmu,Bmu)
print,wavmu,Tb

end

