; file: gasiter_nhtot_test.pro
; init: Sep 16 2013  Rob Rutten
; last: Oct 13 2013  Rob Rutten

;; pro noppes ; dummy, insert for IDLWAVE C+ALT q indentation

; put plot window half besides emacs frame
window,xpos=100,ypos=380,xsi=630

; common with atomic data in the Wittmann-Sanchez-Asensio  programs 
common common_atomdata_wsa,at_weight,at_abu,at_ionerg1,at_ionerg2,at_ionerg3,at_sym
atomdata_wsa,1   ; initialize common with these numbers

; test array input
temp=[7000]
temp=[2000,4000,7000,10000,13000,20000]
temp=indgen(190)*100.+2000. 
nhydtot=[1E16] ; fails
nhtot=1E16
gasiter_nhtot,nhtot,temp,$
  nhtotnew,elpress,pgas,phneutral,phminus,phplus,ph2,ph2plus,$
  /verbose

; plot number densities for inspection 
kcgs=1.380658D-16	 ; Boltzmann constant (erg/deg)
plot,temp,phneutral/(kcgs*temp),/ylog
oplot,temp,elpress/(kcgs*temp),linestyle=2
oplot,temp,ph2plus/(kcgs*temp),linestyle=3
oplot,temp,ph2/(kcgs*temp),linestyle=1
oplot,temp,phminus/(kcgs*temp),linestyle=3
oplot,temp,nhtotnew,psym=4
; wrong at low temp, even at 30 000 iterations wrong below 1000 K

; test scalar input; 1E17,6000 = 4E7 HI/H^min ratio RTSA p178 below (8.3)
gasiter_nhtot,1E17, 6000,$
  nhtotnew,elpress,pgas,phneutral,phminus,phplus,ph2,ph2plus,/verbose
print,'N_HI/N_Hmin = ',ntostr(phneutral/phminus)

end
