; file: exthneuff_rr.pro = neutral hydrogen free-free extinction
; init: Oct 15 2013  Rob Rutten
; last: Nov  6 2013  Rob Rutten

function exthneuff_rr,wav,temp,nhneut,nhplus,nelect

;+
 ; NAME:
 ;   exthneuff_rr   
 ; PURPOSE:
 ;   compute neutral hydrogen free-free extinction per neutral hydrogen atom
 ; DESCRIPTION:
 ;   as Gray 2005 but no Saha assumed for conversion to per neutral hydrogen
 ; CALL:
 ;   exthff=exthneuff_rr(wav,temp,nhneut,nhplus,nelect)
 ; INPUTS:
 ;   wav = wavelength in Angstom, may be an array
 ;   temp = temperature in Kelvin, may be an array but not both together
 ;   nhneut = neutral hydrogen density, may be array with temp
 ;   nhplus = free proton density, may be array with temp
 ;   nelect = free electron density, may be array with temp
 ; OUTPUTS:
 ;   neutral hydrogen free-free extinction in cm^2 per neutral H atom
 ; NOTE:
  ;  result includes correction for stimulated emission since always LTE
 ; HISTORY:
 ;   Oct 15 2013 RR: start   
;-

; answer no-parameter query 
if(n_params(0) lt 5) then begin
  print,'ext=exthneuff_rr(wav,temp,nhneut,nhplus,nelect)  (wav in AA)'
  return,-1
endif

; read physics constants (cgs)
@constants_cgs.idl

; params
theta=5040./temp
lambda=1.D0*wav
nu=ccgs/(lambda*1E-8)

; Gray 2005 (8.6)
gauntff=1.0+0.3456/((lambda*rydbergaa)^0.3333)*$
        (alog10(exp(1))*lambda/(theta*1.239842E4)+0.5)

;; ; Gray 2005 (8.9)
;; sigmaff=(2./3.^1.5)*hcgs^2*eelectron^2*rydbergcm/(!pi*melectron^3) $
;;   *(1./nu*3)*sqrt(2.*melectron/(!pi*kcgs*temp))
;; ;RR wrong outcome, what is wrong?

; Chandrasekhar Stellar Structure eq.(61) p263
; without (1./AH) = not per gram but per cm per proton without N_e
sigmaff=16.*!pi^2/(3.*sqrt(3)) $
  *eelectron^6/(hcgs*ccgs*(2*!pi*melectron)^1.5) $
  *(1./sqrt(kcgs*temp))*(1./nu^3)

; Gray 2005 expression above (8.10)
sigmaff=gauntff*sigmaff*nhplus*nelect/nhneut  ; actual NLTE values 

; correction for stimulated emission (so not my sigma or alpha but a mix)
alphaff=sigmaff*(1.-exp(-hcgs*ccgs/(lambda*cmperaa*kcgs*temp)))

return,alphaff
end


