; file: exthneuff_gray.pro = HI following Gray 1992/2005
; init: Jul  8 2010  Rob Rutten 
; last: Oct  2 2013  Rob Rutten

function exthneuff_gray,wav,temp

;+
; ext=exthneuff_gray(wav,temp)
; in: wavelength [Angstrom]  (value or array but not both arrays)
;     temperature  [K]  (value or array but not both arrays)
; out: sigma H_bf cm^2 per neutral H atom assuming Boltzmann
;      NB: includes stimulated-emission correction already
;-

; answer no-parameter query 
if(n_params(0) lt 2) then begin
  print,'ext=exthneuff_gray(wav,temp)  number[AA], array [K]' 
  return,-1
endif

; read physics constants (cgs)
@constants_cgs.idl

; params
theta=5040./temp
lambda=1.D0*wav

; Gray 2005 (8.6 first equation)
gauntff=1.0+0.3456/((lambda*rydbergaa)^0.3333)*$
        (alog10(exp(1))*lambda/(theta*1.239842E4)+0.5)

; Gray 2005 (8.10)
sigmaff=1.0449E-26*lambda^3*gauntff*alog10(exp(1))*10^(-theta*rydbergev) $
        /(2.*theta*rydbergev)

; correction for stimulated emission (so not my sigma or alpha but a mix)
alphaff=sigmaff*(1.-exp(-hcgs*ccgs/(lambda*cmperaa*kcgs*temp)))

;; print,' ------ ',sigmaff,alphaff,alphaff/sigmaff

return,alphaff
end


