; file: exthminff_gray.pro = H-minus free-free extinction following Gray
; init: sometine in the 1990s for SSB2
; last: Oct  2 2013  Rob Rutten
; note: originally from Gray 2nd edition 1992 p135 ff
;       now 3rd edition 2005

function exthminff_gray,wav,temp,eldens
;+
; ext=exthminff_gray(wav,temp,eldens)
; in:  wav = wavelength [Angstrom] (number or array but then others number)
;      temp = temperature [K]  (number or array)
;      eldens = electron density [electrons cm-3] (number or array)
; out: H-minus ff extinction [cm^2 per neutral hydrogen atom]
;      assuming LTE ionization H/H-min
;      NB: includes stimulated emission correction already!
;-

; answer no-parameter query 
if(n_params(0) lt 3) then begin
  print,'ext=exthminff_gray(wav,temp,eldens)'
  return,-1
endif

; read physics constants (cgs)
@constants_cgs.idl

; other parameters
  ll=1.D0*wav
  theta=5040./temp
  elpress=eldens*kcgs*temp

; evaluate H-min free-free including stimulated emission = Gray 2005 p156
  logll=alog10(ll)
  f0 =  -2.2763 -1.6850*logll +0.76661*logll^2 -0.0533464*logll^3
  f1 =  15.2827 -9.2846*logll +1.99381*logll^2 -0.142631*logll^3
  f2 = -197.789 +190.266*logll -67.9775*logll^2 +10.6913*logll^3 $
       -0.625151*logll^4
  ltheta=alog10(theta)
  kappaff = 1.D-26*elpress*10^(f0+f1*ltheta+f2*ltheta^2)   ; Gray (8.13)

  return,kappaff
end

