; file: exthminbf_wsa.pro
; init: Oct  9 2013  Rob Rutten
; last: Oct  9 2013  Rob Rutten
; note: from otherdirs/asensio/kh_bf.pro

function exthminbf_wsa,temp,elpress,wav

; PURPOSE:
;   compute negative hydrogen bound-free continuum extinction
;   per H atom (cm**2), according to 
;   John, 1989, A&A 193, 189 (he has a couple of mistakes)
;   RJR = 1988A%26A...193..189J  (Jorge's year is also a mistake)
;
; INPUT:
;   temp      temperature (k)
;   elpress   electron pressure
;   wav       wavelength in AA larger than 1250 AA
;
; output:
;   H_min bound-free continuous extinction coefficient
;
; MODIFICATION HISTORY:
;   finished:20/2/90)for SOS
;   Sept 1st, 95fortran > idl (jorge)
;   Oct  9 2013: RJR cosmetics

; definitions & constants
lambda_0=1.6419d0
alfa=1.439d4
const=.75d-18
cc=[152.519d0,49.534d0,-118.858d0,92.536d0,-34.194d0,4.982d0]

; kh_bf
t=temp
pe=elpress
lambda=wav/1.e4
if(lambda lt lambda_0)then begin
  com=1./lambda-1./lambda_0
  e=findgen(6)/2.                ; idl style
  sigma=total(cc*com^e)          ; idl style
  sigma=lambda^3.*com^1.5*sigma
  kh_bf=t^(-2.5)*exp((alfa/lambda_0)/t)*(1.-exp(-(alfa/lambda)/t))
  kh_bf=(const*sigma)*kh_bf
endif else begin
  kh_bf=0.d0*t
endelse

; return
kh_bf=kh_bf*pe

return,float(kh_bf)
end
