; file: exthminbf_gray.pro = H-minus bound-free extinction following Gray
; init: sometime in the 1990s for SSB2
; last: Oct  2 2013  Rob Rutten
; note: originally Gray 1992 (2nd edition) p135 ff; now 3rd edition 2005


function exthminbf_gray,wav,temp,eldens

;+
; ext=exthminbf_gray(wav,temp,eldens)
; in:  wav = wavelength [Angstrom] (number or array but then others number)
;      temp = temperature [K]  (number or array)
;      eldens = electron density [electrons cm-3] (number or array)
; out: H-minus bf extinction [cm^2 per neutral hydrogen atom]
;      assuming LTE ionization H/H-min
;      NB: includes stimulated emission correction already!
;-

; answer no-parameter query 
if(n_params(0) lt 3) then begin
  print,'ext=exthminbf_gray(wav,temp,eldens)'
  return,-1
endif

; read physics constants (cgs)
@constants_cgs.idl

; other parameters
ll=1.D0*wav
theta=5040./temp
elpress=eldens*kcgs*temp

; evaluate H-min bound-free per H-min particle = Gray III (8.11)
; his alpha = my sigma in NGSB/AFYC (per particle without stimulated)
a=[+1.99654,-1.18267D-5,+2.64243D-6,-4.40524D-10,+3.23992D-14,$
   -1.395568D-18,+2.78701D-23]
sigmabf=0
for i=0,6 do sigmabf=sigmabf+a[i]*ll^i
sigmabf=sigmabf*1E-18  ; cm^2 per H-min ion

; cutoff at H-min ionization limit 
if total((ll ge 16444)) then sigmabf[where(ll ge 16444)]=0.  
    ; Thijs Krijger trick to permit wavelength array input

; convert into bound-free per neutral H atom assuming Saha = Gray 2005 (8.12
; units: cm2 per neutral H atom in whatever level (the whole stage)
graysaha=4.158E-10*elpress*theta^2.5*10.^(0.754*theta) 
kappabf=sigmabf*graysaha                               

; correct for stimulated emission
kappabf=kappabf*(1.-exp(-hcgs*ccgs/(ll*1E-8*kcgs*temp))) 

; STOP

return,kappabf
end

