; file: extcont_test_falc.pro = lots of little continuous extinction tests
; init: Oct  9 2013  Rob Rutten
; last: Oct 16 2013  Rob Rutten

;; pro noppes ; dummy, insert for IDLWAVE C+ALT q indentation

; put plot window besides emacs frame
window,xpos=0,ypos=380,xsi=630

; read physics constants (cgs)
@constants_cgs.idl

; read FALC (from ssb3.pro)
falcfile='/home/rutten/rr/web/rjr-edu/exercises/ssb/falc.dat'
falcstruct={height:0.0,tau5:0.0,mass:0.0,temp:0.0,v_mic:0.0,$
            n_h:0.0,n_p:0.0,n_e:0.0,p_tot:0.0,p_ratio:0.0,dens:0.0}
read_struct,falcfile,falcstruct,falc,nlines=80,/silent
height=falc.height  ; in km 
temp=falc.temp
nhtot=falc.n_h
nproton=falc.n_p
nhneutral=nhtot-nproton ; this includes H2 molecules
nelectron=falc.n_e
elpress=nelectron*kcgs*temp
ptot=falc.p_tot
pgas=ptot*falc.p_ratio  ; gas component only 
gasdens=falc.dens
vmicro=falc.v_mic
nh=80

wav=5896.  ; NaD1
wav=5000.  ; Angstrom

; get gray continuum extinction
; NB the Gray recipes include correction for stimulated emission already

exthminbfg=exthminbf_gray(wav,temp,nelectron)
exthminffg=exthminff_gray(wav,temp,nelectron)
exthneubfg=exthneubf_gray(wav,temp)
exthneuffg=exthneuff_gray(wav,temp)
extthomson=0.664E-24
extrayleigh=1.13/2.*0.664E-24*(1216./wav)^4+0.*temp  ; array
extcontHg=exthminbfg+exthminffg+exthneubfg+exthneuffg
extcontg=extcontHg*nhneutral+extthomson*nelectron+extrayleigh*nhneutral

; inspect
plot,height,extcontg,/ylog

; STOP

; extheubf: apply ad-hoc NLTE correction for Paschen continuum from SSB3.pro
saha_mc,temp,nelectron,13.6,partfunc_rr(temp,1,0),1,n1_ntot,n0_ntot
bproton=(nproton/nhtot)/n1_ntot 

plot,height,bproton  ; OK, just as fig-betas-FALC-HI.eps 
; this is b_c; fig HI-betas FALC shows b3 shares pattern at smaller amplitude
bn3=1.-0.7*(1.0-bproton)  ; 0.7 = rough fix
oplot,height,bn3,linestyle=2

; STOP

plot,height,exthneubfg,/ylog
oplot,height,exthneubfg*bn3,linestyle=2

; STOP

; exthneuff_gray: LTE Saha assumption for N_p/N_Nneutral is wrong
; so use my version without Saha
exthneuffrr=exthneuff_rr(wav,temp,nhneutral,nproton,nelectron)

plot,height,exthneuffrr,/ylog
oplot,height,exthneuffg,linestyle=2 

; the difference is hydrogen NLTE = b_c/b_NHneutral approx b_c/b_1
; NB: the metal donors are properly included via N_e in Saha

; STOP

plot,height,(exthneuffg-exthneuffrr)/exthneuffrr,yrange=[-0.5,2.0],ystyle=1
; Gray 20% too large at h=300 km, doesn't solve my SSB3 low-continuum problem

; I also tried to improve exthnebf_gray.pro by another Gaunt factor
; following RH, taken from Seaton 1960RPPh...23..313S
exthneubfrr=exthneubf_rr(wav,temp)
plot,height,exthneubfg,/ylog
oplot,height,exthneubfrr,linestyle=2 ; virtually identical

; STOP

plot,height,(exthneubfg-exthneubfrr)/exthneubfrr,/ynozero
; Seaton gives 9% smaller Gaunt factors for n=3 Paschen continuum
; that seems a bit much.  But RH has larger cont extinction in ssb3.pro
STOP

; apply both corrections
extcontH=exthminbfg+exthminffg+exthneubfg*bn3+exthneuffrr
extcont=extcontH*nhneutral+extthomson*nelectron+extrayleigh*nhneutral

; plot the corrected total and the various contributions
plot,height,extcont,/ylog,yrange=[1E-16,1E-5],ystyle=1
oplot,height,exthminbfg*nhneutral,linestyle=1
oplot,height,exthminffg*nhneutral,linestyle=2
oplot,height,exthneubfg*nhneutral,linestyle=2     ; > Thomson in chromosphere
oplot,height,exthneubfg*bn3*nhneutral,linestyle=2 ; < Thomson in chromosphere
oplot,height,exthneuffrr*nhneutral,linestyle=3    ; everywhere negligible
oplot,height,extthomson*nelectron,linestyle=1
oplot,height,extrayleigh*nhneutral,linestyle=3 ; surprisingly important 900 km

STOP

; see SSB3 .pro for more discussion.  Thomson dominates in
; chromosphere thanks to the bn3 (Paschen continuum) population
; deficit which is part of the recombination ladder including Halpha
; losses (but no suction, I tested that last year).

; ===== compare these to LTE ionization with the WSA routines

; add common with atomic data for the Wittmann-Sanchez-Asensio programs 
common common_atomdata_wsa,at_weight,at_abu,at_ionerg1,at_ionerg2,at_ionerg3,at_sym
atomdata_wsa,1   ; initialize this common
pe=elpress
gaspress_wsa,pe,temp,ph,phmi,phpl,ph2,ph2pl,pg,rho

; inspect particle densities
plot,height,nhneutral>1E10,/ylog
oplot,height,ph/(kcgs*temp),linestyle=2
  ; much smaller but can't be NLTE, H b1 increases only > 1500 km
oplot,height,nproton,linestyle=1
oplot,height,phpl/(kcgs*temp),linestyle=2
  ; very small difference, so large neutral discrepancy is not ionization
oplot,height,nelectron                   ; nothing to do with donor electrons
oplot,height,ph2/(kcgs*temp),linestyle=3 ; H2 molecules
  ; interesting: needs low T and high pH so most in mid photosphere
oplot,height,phmi/(kcgs*temp),linestyle=1 ; drops out of sight
; Hmin lies 7 dex below Hneutral!

; STOP

; compare Hmin density to hydrogen n=3 density for Paschen continuum 
plot,height,phmi/(kcgs*temp),/ylog,yrange=[1E0,1E12],ystyle=1
oplot,height,nhneutral*(18./2.) $
  *exp(-(10.2D0+evperaa/6563.)/(kev*temp)),linestyle=2
; OK; this should be done in SSB2 (or is it there already?)

; STOP

plot,height,pgas,/ylog     ; pgas = without turbulent pressure
oplot,height,ptot,linestyle=1
oplot,height,pg,linestyle=2
; same large difference as before

; STOP

plot,height,gasdens,/ylog
oplot,height,rho,linestyle=2
; same large difference

; STOP

; gaspress_wsa is for fixed elpress which is a funny constraint since
; the neutral-electon mixture changes with the degree of ionization.
; So use gasiter_nhtot.pro for the FALC NHtot valeus
pe=elpress
gasiter_nhtot,nhtot,temp,$
  nhtotnew,penew,pgnew,phnew,phminew,phplnew,ph2new,ph2plnew,rhonew
plot,height,gasdens,/ylog
oplot,height,rho,linestyle=2
oplot,height,rhonew,psym=4
; OK, LTE gas density now equals the FALC density

; STOP

; now repeat the above particle-density FALC - WSA comparisons
plot,height,nhneutral>1E10,/ylog
oplot,height,phnew/(kcgs*temp),linestyle=2
  ; OK, FALC has HI overpopulation towards TR
oplot,height,nproton
oplot,height,phplnew/(kcgs*temp),linestyle=2
  ; OK, FALC underionization more noticeable in minority stage = protons
  ; but so LTE would have many more electrons for Thomson?
oplot,height,nelectron
oplot,height,penew/(kcgs*temp),linestyle=2
  ; WSA routines properly treat the electron donors, then fail in H NLTE
oplot,height,(penew-phplnew+phplnew*bproton)/(kcgs*temp),psym=4
  ; overcorrection, why?

; STOP

; =========== now try the original WSA extinction routines

; open the Asensio directory to IDL
cd, '/home/rutten/rr/idl/otherlibs/asensio',current=thisdir
addtopath
cd,thisdir

; extcont
pe=elpress
forward_function kappa_c ; needed because IDL thinks it is an array variable
kappacont=kappa_c(pe,temp,wav,htoverv,rmu)
; NB: these still have the old element abundances

plot,height,extcont,/ylog
oplot,height,kappacont*htoverv,linestyle=2  ; htoverv = WSA-computed nHtot
; OOPS: identical until h=700 km but large differences at larger height

oplot,height,kappacont*nhtot,linestyle=3
; large differences just the other way

; STOP

plot,height,(htoverv-nhtot)/nhtot
; yes, order magnitude difference in chrom but also growth to 10%
; excess over photosphere.  What is the deeper part?

; STOP

; oplot H_minus only
; Hmin: John 1988A%26A...193..189J also includes stimulated emission, Saha LTE
hminbf=kh_bf(temp,elpress,wav)
hminff=kh_ff(temp,elpress,wav)
kappacont=(hminbf+hminff)*nhtot
plot,height,extcont,/ylog
oplot,height,kappacont,psym=5
; WSA values smaller at depth = missing exthneu

; STOP

; compare the two Hmin bf routines
plot,height,(hminbf-exthminbfg)/exthminbfg
; only 3 promille difference in T-min

; STOP

; compare the two Hmin ff routines 
plot,height,(hminff-exthminffg)/exthminffg,yrange=[-0.005,0.005],ystyle=1
; up to 5 promille difference only

; STOP

; compare the Hneutral routines (bf Paschen continuum + ff = protons)
hneu=kh(temp,wav)
exthneug=exthneubfg+exthneuffg       ; Gary version
exthneuc=exthneubfg*bn3+exthneuffrr  ; my NLTE corrections

plot,height,hneu,/ylog
oplot,height,exthneug,linestyle=2
oplot,height,exthneuc,linestyle=3

; STOP

; some WSA routines are per H particle but not this one I think
; would give difference when H ionizes:
plot,height,(hneu*nhtot/nhneutral-hneu)/hneu,yrange=[-0.01,0.05]
; but there is no Saha in the routine so it is per neutral atom
; but so I think there is no Hneuff in kh.pro.  Check reference.
; Oops, Mihalas in Methods Computational Physics Vol 7 = $214 on Amazon.

; STOP

plot,height,(hneu-exthneug)/exthneug,yrange=[-0.2,0.2],ystyle=1
; growth to 4% difference in T-min, bit too much although Hmin dominates
; at hat height anyhow, and in the deep where HI contributes the
; difference is only 1 percent.  My Gray plots also have a few
; percent lower H_bf peaks than in his figures.  I tested the
; Boltzmann summation cutoff without getting significant difference.
; Nevertheless, the difference with Gray himself is strange.

oplot,height,(hneu-exthneuc)/exthneuc,linestyle=2
; NLTE 

; STOP

; test the MgI contribution
mgneu=kmg(temp,elpress,wav)
plot,height,hneu,/ylog
oplot,height,exthneug,psym=5       ; the same 
oplot,height,exthneuc,linestyle=3  ; this correction also affects WSA
oplot,height,mgneu
; WOW - remember that the Rydberg levels for Mg have more population than H?
; funny jagged function: the pro says "no interpolation"

oplot,height,exthminbfg,linestyle=1
; so it doesn't really matter, Hmin >> Hneu where Mg > Hneu wait:
; particle densities?  No, everything is per neutral H, except Mg is
; per H in whatever state, but NHtot approx Nneutral anyhow
oplot,height,mgneu*nhtot/nhneutral,psym=4 ; only deviation at the top
; conclusion: MgI contribution negligible

; STOP

; test WSA Rayleigh scattering
rayleigh=srh(wav)+0.*temp
plot,height,extrayleigh*nhneutral,/ylog
oplot,height,rayleigh*nhneutral,linestyle=2 
print,' ===== rayleigh_wsa/rayleigh_rr =',ntostr(rayleigh[0]/extrayleigh[0])
; WSA value 22% smaller, not larger alas...

; STOP

; test WSA Rayleigh scattering on H2 molecules
gaspress_wsa,elpress,temp,ph,phmi,phpl,ph2,ph2pl,pg,rho
rayh2=srh2(wav,ph,ph2)
plot,height,rayh2/extrayleigh>1E-8,/ylog
; less than a promille of H atoms Rayleigh scattering, negligible

end
