; file: electron_wsa.pro 
; init: Oct  1 2013  Rob Rutten
; last: Oct  6 2013  Rob Rutten

function electron_wsa,elemnr,temp,pe

; Computes the number of electrons which a given element releases
; to the medium over the number of hydrogen atoms using Saha.  It is
; required by gaspress_wsa.
;
; input:
;	elemnr	 element number
;	temp 	 temperature (K)
;	pe	 electron pressure
;
; output:
;	returns number of electrons times abundance = per H atom in any type
;
; MODIFICATION HISTORY:
; Sep  1 1995: Fortran > IDL (Jorge Sanchez Almeida)
; Sep 17 2013: RJR cosmetics
; Oct  5 2013: variable name changes, cosmetics

; atomic data in common for the WSA programs 
common common_atomdata_wsa,at_weight,at_abu,at_ionerg1,at_ionerg2,at_ionerg3,at_sym

; double Saha  ;RR this routine is not used for hydrogen so no problem
partfunc_wsa,temp,elemnr,u1,u2,u3
n1overn0=saha_wsa(temp,pe,u1,u2,at_ionerg1(elemnr-1))
n2overn1=saha_wsa(temp,pe,u2,u3,at_ionerg2(elemnr-1))
n1overn=n1overn0/(1.+n1overn0*(1.+n2overn1))
n2overn=n2overn1*n1overn	
electron_wsa=at_abu(elemnr-1)*(n1overn+2*n2overn)

return, electron_wsa
end
