; file: atomdata_wsa,pro = fill common with atom data
; init: Oct  5 2013  Rob Rutten - from WSA file
; last: Nov 21 2013  Rob Rutten  Sac Peak

pro atomdata_wsa,nrelem,atwgt,atabu,atei1,atei2,atei3,atsym

;+
; PURPOSE:
;     supplies atomic parameters for 92 elements (hydrogen to uranium)
;     adapted from the routine with the same name of
;     A.D. Wittmann, Goettingen (1974, solar phys. 35, 11)
;
;     In fact the original routine has been split into two,
;     ATMDAT_wsa, which provides atomic parameters and PARTITION_wsa,
;     which computes partfunc_wsa functions (depending on temperature
;     and pressure).
;
; INPUT:
;	nrelem	atomic number, may be array
; OUTPUT:
;	wgt	atomic weight (c12=12.00)
;	abu	abundance, by number, referred to h (not in logaritms)
;	ei1	1st ionization potential (ev)
;	ei2	2nd	"	  "        "
;       ei3     3rd 
;	symbol	symbol corresponding to the elements
; COMMON:
;	 common_atomdata_wsa,at_weight,at_abu,at_ionerg1,$
;               at_ionerg2,at_ionerg3,at_sym
;               therefore, you can also access this data set by
;               including this common block after a first call to
;               ATMDAT

; MODIFICATION  HISTORY:
;  1975, Axel Wittmann in Fortran (RJR: at least, I think so)
;  22/2/90, just adding comments (Jorge Sanchez Almeida)	
;  6/3/90   change of abundances to Grevesse: 1984, Phys. Scripta t8, 49
;  August 31st, 95 translated to IDL with split into two routines (JOS)
;  May 2000, symbols included (JOS?)
;  Sep 16 2013 RJR: test on nrelem changed to admit array input
;  Sep 17 2013 RJR: abundances > Asplund++ 2009ARA&A..47..481A; caps names
;  Oct  5 2013 RJR: changed pro name, common name, variable names 
;  Nov 21 2013 RJR: changed ion energies to wikipedia values, added 3rd 
;-

; common definition for the WSA programs 
common common_atomdata_wsa,at_weight,at_abu,$
  at_ionerg1,at_ionerg2,at_ionerg3,at_sym

; checking nr of element
na=92
if(min(nrelem) lt 1 or max(nrelem) gt na) then stop,'atomdata_wsa: no data'

;RR sym = element abbreviations (use nrelem-1 in view of IDL zero start)
at_sym=['H','He','Li','Be','B','C','N','O','F','Ne',$
     'Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr',$
     'Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr',$
     'Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In']
; and more
at_sym=[at_sym,'Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce',$
     'Pr','Nd','Pm',$
     'Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W',$
     'Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn',$
     'Fr','Ra','Ac','Th','Pa','U']

;RR w = atomic weights (AQ p31)
at_weight=[1.008,4.003,6.939,9.012,10.811,12.011,14.007,16.,18.998,$
   20.183,22.99,24.312,26.982,28.086,30.974,32.064,35.453,39.948,39.102,$
   40.08,44.956,47.90,50.942,51.996,54.938,55.847,58.933,58.71,63.54,$
   65.37,69.72,72.59,74.92,78.96,79.91,83.80,85.47,87.62,88.905,91.22,$
   92.906,95.94, 99.00,101.07,102.9,106.4,107.87,112.40,114.82]
; and more
at_weight=[at_weight,118.69,121.75,127.6,126.9,131.3,132.9,137.34,$
   138.91,140.12,140.91,$
   144.24,147.00,150.35,151.96,157.25,158.92,162.50,164.93,$
   167.26,168.93,173.04,174.97,178.49,180.95,183.85,186.2,190.2,192.2,$
   195.09,196.97,200.59,204.37,207.19,208.98,210.,211.,222.,$
   223.,226.1,227.1,232.04,231.,238.03]

;RR e1 = first ionization energy in eV
at_ionerg1=[13.598,24.59,5.39,9.32,8.30,11.26,14.53,13.62,17.42,$
    21.56,5.14,7.65,5.99,8.15,10.49,10.36,12.97,15.76,4.34,$
    6.11,6.56,6.83,6.75,6.77,7.43,7.90,7.88,7.64,7.73,9.39,$
    6.00,7.90,9.79,9.75,11.82,14.00,4.18,5.70,6.22,6.64,6.76]
; and more
at_ionerg1=[at_ionerg1,7.09,7.28,7.36,7.46,8.34,7.57,8.99,5.79,7.34,$
    8.61,9.01,10.45,$
    12.13,3.89,5.21,5.58,5.54,5.47,5.53,5.58,5.64,5.67,6.15,$
    5.86,5.94,6.02,6.11,6.18,6.25,5.43,6.83,7.55,7.86,7.83,$
    8.44,8.97,8.96,9.23,10.44,6.11,7.42,7.29,8.42,9.30,10.75,$
    4.07,5.28,5.17,6.31,5.89,6.19]

;RR e2 = second ionization energy in eV
at_ionerg2=[0.00,54.42,75.64,18.21,25.15,24.38,29.60,35.12,34.97,40.96,$
    47.29,15.04,18.83,16.35,19.77,23.34,23.81,27.63,31.63,11.87,$
    12.80,13.58,14.66,16.49,15.64,16.19,17.08,18.17,20.29,17.96,$
    20.51,15.93,18.63,21.19,21.8,24.36,27.29,11.03,12.24,13.13]
; and more
at_ionerg2=[at_ionerg2,14.32,16.16,15.26,16.76,18.08,19.43,21.49,16.91,$
    18.87,14.63,$
    16.53,18.6,19.13,21.21,23.16,10.00,11.06,10.85,10.55,10.73,$
    10.90,11.07,11.24,12.09,11.52,11.67,11.80,11.93,12.05,$
    12.18,13.9,14.9,16.2,17.7,16.60,17.00,20.00,18.56,20.5,18.76,$
    20.43,15.03,16.69,19.000,20.000,20.000,22.00,10.15,12.1,11.5,12.000,$
    14.79]

;RR e3 = third ionization energy in eV (mostly Astrophysical Quantities)
; http://en.wikipedia.org/wiki/Ionization_energies_of_the_elements_(data_page)
at_ionerg3=[0,0,122.451,153.893,37.930,47.887,47.448,54.934,62.707,$
    63.45,71.64,80.143,28.448,33.492,30.18,34.83,39.61,40.74,45.72,$
    50.91,24.76,27.49,29.31,30.96,33.67,30.651,33.50,35.17,36.83,39.72,$
    30.71,34.22,28.351,30.820,36,36.95,40,43.6,20.52,22.99,25.04,27.16]
; and more
at_ionerg3=[at_ionerg3,29.54,28.47,31.06,32.92,34.83,37.48,28.03,30.502,$
    25.3,27.96,33,32.1,35,37.5,19.177,20.20,21.62,22.1,22.3,23.4,24.92,$
    20.63,21.91,22.8,22.84,22.74,23.68,25.05,20.96,23.3,25.000,25.000,$
    26.15,25.000,25.000,25.000,25.000,34.2,29.83,31.94,25.56,25.000,$
    25.000,25.000,25.000,25.000,25.000,20.0,25.000,25.000]

;; ;RR eps = element abundance by number on log scale with H=12
;; ;RR Grevesse 1984, Phys. Scripta t8, 49 = ADS 1984PhST....8...49G
;;  eps=[12.00,11.00,1.00,1.15,2.60,8.69,7.99,8.91,4.56,8.00,6.33,7.58,$
;; 6.47,7.55,5.45,7.21,5.50,6.58,5.12,6.36,3.10,5.02,4.0,5.67,5.45,$
;; 7.67,4.92,6.25,4.21,4.60,2.88,3.63,2.30,3.20,2.60,3.20,2.60,2.90]
;; eps=[eps,2.10,2.75,1.95,2.16,0.00,1.83,1.20,1.50,0.85,1.85,1.65,1.90,$
;; 1.10,2.00,1.40,2.00,1.10,2.09,1.13,1.55,0.71,1.50,0.00,1.00,0.70,1.12,$
;; .40,1.06,.50,.80,.26,1.00,.76,.80,.30,1.10,.60,1.00,1.00,1.75,.75,$
;; .90,.90,1.93,.70,-8.,-8.,-8.,-8.,-8.,-8.,0.28,-8.,0.]

;RR abundances Asplund et al. 2009ARA&A..47..481A
at_eps=[12.00,10.93,1.05,1.38,2.70,8.43,7.83,8.69,4.56,7.93,6.24,7.60,$
     6.45,7.51,5.41,7.12,5.50,6.40,5.03,6.34,3.15,4.95,3.93,5.64,5.43,$
     7.50,4.99,6.22,4.19,4.56,3.04,3.65,2.30,3.20,2.60,3.25,2.52,2.87]
; and more; above = element 1-38 
at_eps=[at_eps,2.21,2.58,1.46,1.88,0.00,1.75,0.91,1.57,0.94,1.85,$
     0.80,2.04,1.10,2.00,1.40,2.24,1.10,2.18,1.10,1.58,0.72,1.42,-8.0,$
     0.96,0.52,1.07,0.30,1.10,0.48,0.92,0.10,0.84,0.10,0.85,.80,0.85,$
     1.10,1.40,1.38,1.00,0.92,.75,$
     .90,1.75,1.93,0.70,-8.,-8.,-8.,-8.,-8.,0.02,0.28,-8.,0.]

; fill the call variables
atwgt=at_weight(nrelem-1)
atei1=at_ionerg1(nrelem-1)
atei2=at_ionerg2(nrelem-1)
atei3=at_ionerg3(nrelem-1)
at_abu=10^(at_eps-12.)
atabu=at_abu(nrelem-1)
atsym=at_sym(nrelem-1)

; how to check abundances against the input table in the literature
  ;; .com atomdata_wsa
  ;; atomdata_wsa,indgen(92)+1,wgt,abu,ei1,ei2,ei3,sym 
  ;; for i=0,91 do print,i+1,' ',sym[i],'   ',$
  ;;     ntostr(alog10(abu[i])+12,format='(F10.2)'),'    ',$
  ;;     ntostr(abu[i],format='(E10.2)')

end
