; file: iris_cuttimesfile.pro
; init: Mar 28 2018  Rob Rutten  Deil
; last: Mar 28 2018  Rob Rutten  Deil

;+

pro iris_cuttimesfile,infile,outaddendum,trange,obsdate=obsdate

 ; PURPOSE:
 ;   cut IRIS or similar times file to smaller time segment  
 ; CALL:
 ;   see above
 ; INPUTS:
 ;   infile = string (including full path)
 ;   outaddendum = substring to add at output file end (eg 'SST')
 ;   trange=[itstart,itend] time segment specification
 ;   obsdate = date, required for SST files in format '2016.09.05'
 ; OUTPUTS:
 ;   outfile
 ; HISTORY:
 ;   Mar 28 2018 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 3) then begin
  sp,iris_cuttimesfile
  return
endif

; defaults for keywords
if (n_elements(obsdate) eq 0) then obsdate=''

; get extension  
dummy=cgrootname(infile,extension=inext)  ;RR needs coyotelib

; SST format timing file or my (RR) stadard format
if (inext eq 'sav' or inext eq 'idlsave') then begin
  if (obsdate eq '') then begin
    print,' ##### iris_cuttimesfile error: SST file needs obsdate'
    return
  endif
  restore,infile 
  timearr_in=obsdate+'_'+time
endif else $
; my (RR) ascii format times files
  if (inext eq 'txt') then readcol,infile,timearr_in,format='(A)' $
  else begin
  print,' ##### iris_cuttimesfile error: no known file extension'
  return
endelse

; check trange versus duration 
if (trange[0] lt 0 or trange[1] gt n_elements(timearr_in)) then begin
  print,' ##### iris_cuttimesfile error: trange larger extent than infile'
  return
endif

; cut the time array
timearr_out=timearr_in[trange[0]:trange[1]]

; write output file in my (RR) ascii times format 
path=file_dirname(infile)
outfile=path+'/'+file_basename(infile,'.'+inext)+'_'+outaddendum+'.txt'
writecol,outfile,timearr_out,fmt='(A)'

end

; ============================== run per Hyper-C 

infile='/media/rutten/SSTDATA/alldata/SST/2014-06-21-quiet/iris/target/iris_SJI_1400-times.txt'
outaddendum='SST'
trange=[0,10]

iris_cuttimesfile,infile,outaddendum,trange,obsdate=obsdate

end
