; file: twoflickrr.pro = double flickrr
; init: Nov 1 1990 Herbie Cohl, Sacramento Peak Observatory
; last: Mar 16 2019  Rob Rutten  Deil

;+
pro twoflickrr,a1,a2,a3,a4,delay,help=help

;	twoflickrr.pro
;
;	hsc		11/1/90		
;
;	This procedure, given four images a1 - a4, 
;	will flickrr between the images, with a time 
;	delay between images, displayed in an IDL   
;	window. 
;	
;	This function was originally written by Steve Keil. 
;
;	Category : IMAGE PROCESSING
;
;           ------------INPUT-------------			
;
;	a1	-	The first image.
;			type: array, any type.
;
;	a2	-	The second image.  
;			type: array, any type.
;
;	delay	-	If present, delay specifies the delay between 
;			the flickrring between two images in seconds.
;			type: scalar,floating point
;
;           ------------OUTPUT------------			
;
;	...	-	FLICKERING IMAGES
;-

  ; Display idl header if help is required.
  if keyword_set(help) or n_params() lt 4 then begin
    print,' twoflickrr,a1,a2,a3,a4,delay'
    goto,finishup
  endif

  if (n_elements(delay) eq 0l) then sdelay=0.00001
  if (n_elements(delay) ne 0l) then sdelay=delay

  ; Byte scale images
  na1=bytscl(a1)
  na2=bytscl(a2)
  na3=bytscl(a3)
  na4=bytscl(a4)

  ; Scale Images
  output1=235*na1/255.
  output2=235*na2/255.
  output3=235*na3/255.
  output4=235*na4/255.
  while get_kbrd(0) eq ''  do begin
   for istep=1,10 do begin 
    tv,output1
    wait,sdelay
    tv,output2
    wait,sdelay
   endfor
  for istep=1,10 do begin 
    tv,output3,0,200
    wait,sdelay
    tv,output4,0,200
    wait,sdelay
   endfor
  endwhile

  finishup:

end

