; file: scalexga.pro = scale image to 16-fold XGA 
; last: Jul 25 2003 
; init: Jul 25 2003 
; site: rridl
; note: mpeg_encode wants multiple of 16 px

pro scalexga,image,scalefactor,nx1,ny1

;+
; pro scalexga,in,out
;   image = image to be rescaled (any type)
;   scalefactor = linear scaling factor (output)
;   nx1,ny1 = new image size (output)
;-

; display input params
if (n_params(0) lt 1) then begin
   print,'  scalexga,image,scalefactor'
   return
endif

; get input image size
sizeim=size(image)
nx0=sizeim(1)
ny0=sizeim(2)

; find scale factor to fit image to XGA display
nxxga=1020   ; full screen 1024;  1020 = max fitting player windows
nyxga=750    ; ful screen 768;    740 = max fitting player windows
scalefactor=fltarr(2)+1.
scalefactor(0) = float(nxxga)/nx0
scalefactor(1) = float(nyxga)/ny0
scalefactor=min(scalefactor)
nx1=fix(scalefactor*nx0+.1)
ny1=fix(scalefactor*ny0+.1)

; change scale to get multiple of 16 in x
nx1=fix(nx1/16.)*16  
scalefactor=float(nx1)/nx0  
ny1=fix(scalefactor*ny0+0.5)

; resize with congrid
image=congrid(image,nx1,ny1,/interp)

; now cut y down to multiple of 16
ny1=fix(ny1/16.)*16    
image=image(0:nx1-1,0:ny1-1)

end
