; file: pxmaxcube.pro = take for each px its temporal max
; init: Aug  8 2020  Rob Rutten  Deil
; last: Aug  8 2020  Rob Rutten  Deil

;+
function pxmaxcube,incube
 ;
 ; INPUTS:
 ;  incube (3D, any size or type) 
 ; 
 ; OUTPUTS:
 ;  image, same type and nx,ny with temporal max value per px  
 ;   
 ; HISTORY:
 ;   Aug  8 2020 Rob Rutten  
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,pxmaxcube
  return,-1       ;RR return,-1 when this is a function
endif

; do it
sz=size(incube)
nx=sz[1]
ny=sz[2]
maxim=incube[*,*,0]
for ix=0,nx-1 do begin
  for iy=0,ny-1 do begin
    maxim[ix,iy]=max(incube[ix,iy,*])
  endfor
endfor

return,maxim
end


; =============== main for testing per IDLWAVE H-c ======================

end
