; file: playassocloop.pro = play assoc images in movie loop
; init: Dec 25 2003 from old flickrr.pro
; last: Nov  9 2013  Rob Rutten

pro playassocloop,assocunit,it1,it2,delay-delay,mag=mag,nobyt=nobyt

;+
 ; NAME:
 ;   playassocloop
 ; PURPOSE:
 ;   play image sequence as movie with autofit to screen size 
 ; CALLING SEQUENCE: 
 ;   playassocloop,assocunit,it1,it2, [,delay insec]
 ; INPUTS:
 ;   assocunit = open assoc unit number
 ;   it1, it2 begin, end of play sequence
 ; KEYWORD PARAMETERS:
 ;   delay=delay   time delay in s (float, default 1 s)
 ;   mag=mag       magnification factor (float; mag=1 gives original size)
 ;   nobyt=nobyt   no byte scaling prior to projection
 ; OUTPUT:
 ;   active blinker
 ;   terminate: hit any key (IDLWAVE: type CR in shell) 
 ; EXAMPLE:
 ;   playassocloop,1,10,20,delay=0.5
 ; HISTORY:
 ;   Dec 25 2003 RR: start
 ;   Nov  9 2013 RR: revamped as flickrr
;-

; no parameter query return
if (n_params() lt 3) then begin
  print,'  assocloop,assocunit,it1,it2 [,delay=delay,mag=mag,nobyt=nobyt]'
  return
endif

; set delay 
if (n_elements(delay) eq 0) then sdelay=0.00001
if (n_elements(delay) ne 0) then sdelay=delay

; get image size
image=assocunit(it1)
if (usemag ne 1) then $
  image=congrid(image,fix(usemag*imsize[1]),fix(usemag*imsize[2]))
imsize=size(image)
xsize=imsize[1]
ysize=imsize[2]

  ; set default magnification or reduction
screen=get_screen_size()
if (n_elements(mag) eq 0) then $
  usemag=0.8*min([float(screen[0])/xsize,float(screen[1])/ysize]) $
else usemag=mag 

  ; open temporary image-size window but not larger than the screen
border=15 ; seems to be necessary
if (xsize gt screen[0]-border) then xsize=screen[0]-border
if (ysize gt screen[1]-border) then ysize=screen[1]-border
window,xsize=xsize,ysize=ysize ; right-justified to keep IDL shell in view

; display as movie loop 
while get_kbrd(0) eq ''  do begin
  for it=0,it2-it1 do begin
    image=assocunit(it1+it)
    if (n_elements(nobyt) eq 0) then image=bytscl(image)
    if (usemag ne 1) then $
      image=congrid(image,fix(usemag*imsize[1]),fix(usemag*imsize[2]))
    tv,image
    wait,sdelay
  endfor
endwhile

end
