; movie2cube.pro = convert movie to loose png's and then to cube
; init: Jan 26 2013  Rob Rutten  LA Deil
; last: Aug 10 2018  Rob Rutten  Deil

function movie2cube,moviefile,fitsfile=fitsfile,keeppng=keeppng

;+
 ; NAME:
 ;   movie2cube.pro  
 ; PURPOSE:
 ;   convert a movie into a cube with optional fitscube writing
 ; DESCRIPTION:
 ;   uses linux avconv (Ubuntu version of ffmpeg)
 ; CALL:
 ;    cube=movie2cube(moviefile,fits=fits)
 ; INPUTS:
 ;   moviefile = string with path/filename, any format acceptable to avconv
 ; KEYWORDS:
 ;   fitsfile: string with fitsfile for output (default '')
 ;   keeppng =1/0: do not delete png files (default 0)
 ; OUTPUTS:
 ;   cube in memory, optional fitsfile, optional subdir temppng png files 
 ; RESTRICTIONS:
 ;   use only for small movies for which the cube fits into memory
 ;   for larger ones use fitslib movie2fitscube.pro instead   
 ; HISTORY:
 ;   Jan 26 2013 RR: start 
 ;   Jul 15 2013 RR: change from jpg's to png's 
 ;   Nov  8 2013 RR: began to write this anew, then found I had it
 ;   Aug 10 2018 RR: idem dito...
;-

; no-parameter response
if (n_params() lt 1) then begin 
  print,'  usage: cube=movie2cube(moviefile) [, fits=fits]'
  return,0
endif

; default keywords
if (n_elements(fitsfile) eq 0) then fitsfile=''
if (n_elements(keeppng) eq 0) then keeppng=0

; convert movie to png images in subdir
spawn,'mkdir -p temppng'
;; spawn,'ffmpeg -i '+string(moviefile)+' -f image2 temppng/image-%04d.png'
;; gave complaint that ffmpeg will be deprecated, replaced by avconv
spawn,'avconv -i '+string(moviefile)+' -f image2 temppng/image-%04d.png -v quiet'

; get nr images and image size
filelist=file_search('temppng/image*')
szfilelist=size(filelist)
nrfiles=szfilelist[1]
read_png,filelist[0],image
szimage=size(image)  ;; first dimension 3 from colors 

; make movie cube
cube=bytarr(szimage[2],szimage[3],nrfiles)
for it=0,nrfiles-1 do begin 
  read_png,filelist[it],image
  cube[*,*,it]=reform(image[0,*,*])
endfor

; optionally write fits
if (fitsfile ne '') then  writefits,fitsfile,cube

; optionally clean png files
if (keeppng ne 1) then spawn,'rm -rf temppng'

return,cube
end

; ============== main for testing per IDLWAVE H-c ==========================


cd,'/media/rutten/SSTDATA/alldata/SST/2017-05-25-souvik/chromis/cak_scan'
moviefile='cak_linescan_25May2017_network.mp4'
cakcube=movie2cube(moviefile,fitsfile='cak-scan.fits')

end
