; file: morph.pro = flickrr analog but morphs between the two 
; last: Jun 26 2003 flight London-Denver
; note: derived from flickrr.pro

pro morph,a1,a2,delay

; help
if n_params() lt 2 then begin
  print, 'morph,image1,image2,[delay]'
  goto,finishup  
endif

; min delay
if (n_elements(delay) eq 0l) then sdelay=0.00001
if (n_elements(delay) ne 0l) then sdelay=delay

; bytescale images
im1=bytscl(a1)
im2=bytscl(a2)

; get image size
sizeim=size(im1)
nx=sizeim(1)
ny=sizeim(2)

; generate intermediates
immov=bytarr(nx,ny,10)
for i=0,9,1 do immov(*,*,i)=bytscl((1.0-i*0.1)*im1+(i*0.1)*im2)

; now show
while get_kbrd(0) eq ''  do begin
  tv,im1
  wait,sdelay
  for i=0,9 do tv,immov(*,*,i)
  tv,im2
  wait,sdelay
  for i=0,9 do tv,immov(*,*,9-i)
endwhile

finishup:

end
