; make4morphmpeg.pro = morph four images into mpeg movie
; last: Jul  9 2003 
; init: Jul  8 2003 Bozeman


pro make4morphmpeg,$
    im1,im2,im3,im4,$
    label1,label2,label3,label4,$
    nstable,nmorph,morphfilename

;+  
; pro make4morphmpeg,im1,im2,label1,label2,morphfilename
;   im1 = image array (any type)
;   im2 = image array (same size, any type)
;   im3 = image array (same size, any type)
;   im4 = image array (same size, any type)
;   label1 = header text for im1 (string)
;   label2 = header text for im2 (string)
;   label3 = header text for im3 (string)
;   label4 = header text for im4 (string)
;   nstable = number of stable images
;   nmorph = number of transition images 
;   morphfilename = mpeg movie file name
;-

; display input params
if (n_params(0) lt 1) then begin
   print,'  make4morphmpeg,im1,im2,im3,im4,'
   print,'     label1,label2,label3,label4,'
   print,'     nstable,nmorph,morphfilename'
endif

; byte scale the images 
im1=bytscl(im1)
im2=bytscl(im2)
im3=bytscl(im3)
im4=bytscl(im4)

; get image size
sizeim=size(im1)
nx=sizeim(1)
ny=sizeim(2)
immov=bytarr(nx,ny,4*nstable+4*nmorph)
frac=1./nmorph

; make info string images (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny
blank=bytarr(nx,ny)
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label1
im1label=tvrd()
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label2
im2label=tvrd()
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label3
im3label=tvrd()
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label4
im4label=tvrd()
wdelete

; apply label strings
im1(where(im1label gt 1))=255
im2(where(im2label gt 1))=255
im3(where(im3label gt 1))=255
im4(where(im4label gt 1))=255

; generate nstable images = im1
for i=0,nstable-1 do $
  immov(*,*,i)=bytscl(im1)  

; generate nmorph images = morph forward im1 to im2
for i=0,nmorph-1 do $
  immov(*,*,i+nstable)=bytscl((1.0-i*frac)*im1+(i*frac)*im2)

; generate nstable images = im2
for i=0,nstable-1 do $
  immov(*,*,i+nstable+nmorph)=bytscl(im2)  

; generate nmorph images = morph im2 to im3
for i=0,nmorph-1 do $
  immov(*,*,i+2*nstable+nmorph)=bytscl((1.0-i*frac)*im2+(i*frac)*im3)

; generate nstable images = im3
for i=0,nstable-1 do $
  immov(*,*,i+2*nstable+2*nmorph)=bytscl(im3)  

; generate nmorph images = morph im3 to im4
for i=0,nmorph-1 do $
  immov(*,*,i+3*nstable+2*nmorph)=bytscl((1.0-i*frac)*im3+(i*frac)*im4)

; generate nstable images = im4
for i=0,nstable-1 do $
  immov(*,*,i+3*nstable+3*nmorph)=bytscl(im4)  

; generate nmorph images = morph im4 back to im1
for i=0,nmorph-1 do $
  immov(*,*,i+4*nstable+3*nmorph)=bytscl((1.0-i*frac)*im4+(i*frac)*im1)

; write mpeg movie
write_mpeg,morphfilename,immov,/high_qual
print,'  wrote file ', morphfilename
print,'  use: plaympeg ', morphfilename

end

