; make3blinkmpeg.pro = morph three images into mpeg blink sequence for xanim
; last: Jul  9 2003 
; init: Jul  8 2003 Bozeman


pro make3blinkmpeg,$
    im1,im2,im3,$
    label1,label2,label3,$
    blinkfilename

;+  
; pro make3blinkmpeg,im1,im2,im3,label1,label2,label3,blinkfilename
;   im1 = image array (any type)
;   im2 = image array (same size, any type)
;   im3 = image array (same size, any type)
;   label1 = header text for im1 (string)
;   label2 = header text for im2 (string)
;   label3 = header text for im3 (string)
;   blinkfilename = mpeg file name
;-

; display input params
if (n_params(0) lt 1) then begin
   print,'  make3blinkmpeg,im1,im2,im3,'
   print,'     label1,label2,label3,'
   print,'     blinkfilename'
endif

; byte scale the images 
im1=bytscl(im1)
im2=bytscl(im2)
im3=bytscl(im3)

; get image size
sizeim=size(im1)
nx=sizeim(1)
ny=sizeim(2)
immov=bytarr(nx,ny,3)

; make info string images (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny
blank=bytarr(nx,ny)
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label1
im1label=tvrd()
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label2
im2label=tvrd()
tv,blank
xyouts,0.1,0.97,/norm,charsize=2,charthick=1.5,label3
im3label=tvrd()
wdelete

; add label strings as white overlay
im1(where(im1label gt 1))=255
im2(where(im2label gt 1))=255
im3(where(im3label gt 1))=255

; generate mpeg images
immov(*,*,0)=im1
immov(*,*,1)=im2
immov(*,*,2)=im3

; write mpeg movie
write_mpeg,blinkfilename,immov,/high_qual
print,'  wrote file ', blinkfilename
print,'  use: playxanim ', blinkfilename

end

