; make2morphmpeg.pro = IDL pro to morph two images into mpeg movie
; last: Jul 24 2003 
; init: Jul  8 2003 Bozeman from trials ~/rr/wrk/DOT/images/2003/june6


pro make2morphmpeg,im1,im2,xaxisarr,yaxisarr,$
                   label1,label2,nstable,nmorph,morphfilename

;+  
; pro make2morphmpeg,im1,im2,xaxisarr,yaxisarr,label1,label2,
;                    nstable,nmorph,morphfilename
;   im1 = image array (any type)
;   im2 = image array (same size, any type)
;   xaxisarr = x-axis scale array
;   yaxisarr = y-axis scale aaray 
;   label1 = header text for im1 (string)
;   label2 = header text for im2 (string)
;   nstable = number of stable images
;   nmorph = number of fade-over transition images 
;   morphfilename = mpeg movie file name
;-

; display input params
if (n_params(0) lt 1) then begin 
   print,'  make2morphmpeg,im1,im2,xaxisarr,yaxisarr,'
   print,'    label1,label2,nstable,nmorph,morphfilename'
   return
endif

; byte scale the two images 
im1=bytscl(im1)
im2=bytscl(im2)

; get image size
sizeim=size(im1)
nx=sizeim(1)
ny=sizeim(2)

; make axes frame  (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny,/pixmap
blank=bytarr(nx,ny)
tv,blank
contour,im1,xaxisarr,yaxisarr,/nodata,/noerase,$
  xmargin=[0,0],ymargin=[0,0],$
  xtickinterval=10,ytickinterval=10,xthick=2.5,ythick=2.5,$
  xticklen=0.015,yticklen=0.015*ny/nx
im1axes=tvrd()
wdelete

; make info string images (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny,/pixmap
blank=bytarr(nx,ny)
tv,blank
xyouts,0.05,0.95,/norm,charsize=2.2,charthick=1.5,label1
im1label=tvrd()
tv,blank
xyouts,0.05,0.95,/norm,charsize=2.2,charthick=1.5,label2
im2label=tvrd()
wdelete

; apply overlays
im1(where(im1axes gt 1))=0
im2(where(im1axes gt 1))=0
im1(where(im1label gt 1))=255
im2(where(im2label gt 1))=255

; generate nstable images = im1
immov=bytarr(nx,ny,2*nstable+2*nmorph)
frac=1./nmorph
for i=0,nstable-1 do immov(*,*,i)=bytscl(im1)  

; generate nmorph images = morph forward im1 to im2
for i=0,nmorph-1 do $
  immov(*,*,i+nstable)=bytscl((1.0-i*frac)*im1+(i*frac)*im2)

; generate nstable images = im2
for i=0,nstable-1 do $
  immov(*,*,i+nstable+nmorph)=bytscl(im2)  

; generate nmorph images = morph backward im2 to im1
for i=0,nmorph-1 do $
  immov(*,*,i+2*nstable+nmorph)=bytscl((1.0-i*frac)*im2+(i*frac)*im1)

; write mpeg movie
write_mpeg,morphfilename,immov,/high_qual
print,'  wrote file ', morphfilename
print,'  play with: $ plaympeg ', morphfilename

end

